% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghost.R
\name{subset.ggghost}
\alias{subset.ggghost}
\title{Extract a subset of a ggghost object}
\usage{
\method{subset}{ggghost}(x, ...)
}
\arguments{
\item{x}{A ggghost object to subset}

\item{...}{A logical expression indicating which elements to select.
Typically a vector of list numbers, but potentially a vector of logicals or
logical expressions.}
}
\value{
Another ggghost object containing only the calls selected.
}
\description{
Alternative to subtracting calls using `-.gg`, this method allows one to 
select the desired components of the available calls and have those
evaluated.
}
\examples{
## create a ggghost object
tmpdata <- data.frame(x = 1:100, y = rnorm(100))

z \%g<\% ggplot(tmpdata, aes(x,y))
z <- z + geom_point(col = "steelblue")
z <- z + theme_bw()
z <- z + labs(title = "My cool ggplot")
z <- z + labs(x = "x axis", y = "y axis")
z <- z + geom_smooth()

## remove the labels and theme
subset(z, c(1,2,6))
## or
subset(z, c(TRUE,TRUE,FALSE,FALSE,FALSE,TRUE))
}

