% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/johnson_neyman.R
\name{johnson_neyman}
\alias{johnson_neyman}
\alias{spotlight_analysis}
\alias{plot.ggjohnson_neyman}
\title{Spotlight-analysis: Create Johnson-Neyman confidence intervals and plots}
\usage{
johnson_neyman(x, precision = 500, ...)

spotlight_analysis(x, precision = 500, ...)

\method{plot}{ggjohnson_neyman}(
  x,
  colors = c("#f44336", "#2196F3"),
  show_association = TRUE,
  show_rug = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{ggeffects}, as returned by the functions
from this package.}

\item{precision}{Number of values used for the range of the moderator variable
to calculate the Johnson-Neyman interval. This argument is passed down to
\code{pretty(..., n = precision)}. Usually, the default value of 500 is sufficient.
Increasing this value will result in a smoother plot and more accurate values
for the interval bounds, but can also slightly increase the computation time.}

\item{...}{Arguments passed down to \code{hypothesis_test()} (and then probably
further to \code{\link[marginaleffects:slopes]{marginaleffects::slopes()}}).}

\item{colors}{Colors used for the plot. Must be a vector with two color
values. Only used if \code{show_association = TRUE}.}

\item{show_association}{Logical, if \code{TRUE}, highlights the range where values
of the moderator are positively or negtatively associated with the outcome.}

\item{show_rug}{Logical, if \code{TRUE}, adds a rug with raw data of the moderator
variable to the plot. This helps visualizing its distribution.}

\item{verbose}{Show/hide printed message for plots.}
}
\value{
A Johnson-Neyman plot.
}
\description{
Function conduct a spotlight-analysis to create so-called
Johnson-Neyman intervals. The \code{plot()} method can be used to visualize the
results of the Johnson-Neyman test.
}
\details{
The Johnson-Neyman intervals help to understand where slopes are significant
in the context of interactions in regression models. Thus, the interval is only
useful if the model contains at least one interaction term. The function
accepts the results of a call to \code{ggpredict()}, \code{ggeffect()} or \code{ggemmeans()}.
The \emph{first} and the \emph{last} focal term used in the \code{terms} argument of
\code{ggpredict()} etc. must be numeric. The function will then test the slopes of
the first focal terms against zero, for different moderator values of the
last focal term. Use \code{plot()} to create a plot of the results.

To avoid misleading interpretations of the plot, we speak of "positive" and
"negative" associations, respectively, and "no clear" associations (instead
of "significant" or "non-significant"). This should prevent the user from
considering a non-significant range of values of the moderator as "accepting
the null hypothesis".
}
\examples{
\dontrun{
data(efc)
efc$c172code <- as.factor(efc$c172code)
m <- lm(neg_c_7 ~ c12hour * barthtot * c172code, data = efc)

if (requireNamespace("ggplot2") && requireNamespace("marginaleffects")) {
  pr <- ggpredict(m, c("c12hour", "barthtot"))
  johnson_neyman(pr)
  plot(johnson_neyman(pr))

  pr <- ggpredict(m, c("c12hour", "c172code", "barthtot"))
  johnson_neyman(pr)
  plot(johnson_neyman(pr))

  # robust standard errors
  if (requireNamespace("sandwich")) {
    johnson_neyman(pr, vcov = sandwich::vcovHC)
  }
}
}
}
\references{
Bauer, D. J., & Curran, P. J. (2005). Probing interactions in fixed and
multilevel regression: Inferential and graphical techniques. Multivariate
Behavioral Research, 40(3), 373-400. doi: 10.1207/s15327906mbr4003_5

Esarey, J., & Sumner, J. L. (2017). Marginal effects in interaction models:
Determining and controlling the false positive rate. Comparative Political
Studies, 1–33. Advance online publication. doi: 10.1177/0010414017730080

Johnson, P.O. & Fay, L.C. (1950). The Johnson-Neyman technique, its theory
and application. Psychometrika, 15, 349-367. doi: 10.1007/BF02288864

McCabe CJ, Kim DS, King KM. Improving Present Practices in the Visual Display
of Interactions. Advances in Methods and Practices in Psychological Science.
2018;1(2):147-165. doi:10.1177/2515245917746792

Spiller, S. A., Fitzsimons, G. J., Lynch, J. G., & McClelland, G. H. (2013).
Spotlights, Floodlights, and the Magic Number Zero: Simple Effects Tests in
Moderated Regression. Journal of Marketing Research, 50(2), 277–288.
doi:10.1509/jmr.12.0420
}
