% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_range.R
\name{pretty_range}
\alias{pretty_range}
\title{Create a pretty sequence over a range of a vector}
\usage{
pretty_range(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A numeric vector with a range corresponding to the minimum and maximum
  values of \code{x}.
}
\description{
Creates an evenly spaced, pretty sequence of numbers for a
  range of a vector.
}
\examples{
library(sjmisc)
data(efc)

x <- std(efc$c12hour)
x
# pretty range for vectors with decimal points
pretty_range(x)

# pretty range for large range
pretty_range(1:1000)

}
