#' @importFrom dplyr case_when
get_model_function <- function(model) {
  # check class of fitted model
  dplyr::case_when(
    inherits(model, c("wblm", "wbm")) ~ "lm",
    inherits(model, "glimML") ~ "glm",
    inherits(model, "bigglm") ~ "glm",
    inherits(model, "biglm") ~ "lm",
    inherits(model, "speedglm") ~ "glm",
    inherits(model, "speedlm") ~ "lm",
    inherits(model, "lrm") ~ "glm",
    inherits(model, "glmrob") ~ "glm",
    inherits(model, "glmRob") ~ "glm",
    inherits(model, "brglm") ~ "glm",
    inherits(model, "svyglm.nb") ~ "glm",
    inherits(model, "svyglm") ~ "glm",
    inherits(model, "clmm") ~ "glm",
    inherits(model, "glmmTMB") ~ "glm",
    inherits(model, "MCMCglmm") ~ "glm",
    inherits(model, "MixMod") ~ "glm",
    inherits(model, "negbin") ~ "glm",
    inherits(model, "gam") ~ "glm",
    inherits(model, "geeglm") ~ "glm",
    inherits(model, "gamlss") ~ "glm",
    inherits(model, "Gam") ~ "glm",
    inherits(model, "polr") ~ "glm",
    inherits(model, "tobit") ~ "glm",
    inherits(model, "vgam") ~ "glm",
    inherits(model, "vglm") ~ "glm",
    inherits(model, c("logistf", "glm")) ~ "glm",
    inherits(model, "gls") ~ "lm",
    inherits(model, "ols") ~ "lm",
    inherits(model, "ivreg") ~ "lm",
    inherits(model, "gee") ~ "lm",
    inherits(model, "plm") ~ "lm",
    inherits(model, "lm") ~ "lm",
    inherits(model, c("rq", "rqss")) ~ "lm",
    inherits(model, "lmRob") ~ "lm",
    inherits(model, "lm_robust") ~ "lm",
    inherits(model, "lme") ~ "lm",
    inherits(model, "truncreg") ~ "lm",
    inherits(model, "glmerMod") ~ "glm",
    inherits(model, "betareg") ~ "betareg",
    inherits(model, "coxph") ~ "coxph",
    inherits(model, "nlmerMod") ~ "lm",
    inherits(model, c("zeroinfl", "hurdle", "zerotrunc")) ~ "glm",
    inherits(model, c("lmerMod", "merModLmerTest", "rlmerMod")) ~ "lm",
    TRUE ~ "glm"
  )
}

#' @importFrom dplyr case_when
get_predict_function <- function(model) {
  # check class of fitted model
  dplyr::case_when(
    inherits(model, c("wblm", "wbm")) ~ "wbm",
    inherits(model, "glimML") ~ "glimML",
    inherits(model, "ols") ~ "ols",
    inherits(model, "lrm") ~ "lrm",
    inherits(model, "lmrob") ~ "lmrob",
    inherits(model, "glmrob") ~ "glmrob",
    inherits(model, "glmRob") ~ "glmRob",
    inherits(model, "brglm") ~ "glm",
    inherits(model, "bigglm") ~ "glm",
    inherits(model, "biglm") ~ "lm",
    inherits(model, "speedglm") ~ "glm",
    inherits(model, "speedlm") ~ "lm",
    inherits(model, "svyglm.nb") ~ "svyglm.nb",
    inherits(model, "svyglm") ~ "svyglm",
    inherits(model, "stanreg") ~ "stanreg",
    inherits(model, "brmsfit") ~ "brmsfit",
    inherits(model, "gamlss") ~ "gamlss",
    inherits(model, "gam") ~ "gam",
    inherits(model, c("tobit", "survreg")) ~ "tobit",
    inherits(model, "Gam") ~ "Gam",
    inherits(model, "MCMCglmm") ~ "MCMCglmm",
    inherits(model, "glmerMod") ~ "glmer",
    inherits(model, "glmmTMB") ~ "glmmTMB",
    inherits(model, "nlmerMod") ~ "nlmer",
    inherits(model, c("lmerMod", "merModLmerTest", "rlmerMod")) ~ "lmer",
    inherits(model, "lme") ~ "lme",
    inherits(model, "logistf") ~ "logistf",
    inherits(model, "ivreg") ~ "ivreg",
    inherits(model, "gls") ~ "gls",
    inherits(model, "geeglm") ~ "geeglm",
    inherits(model, "clmm") ~ "clmm",
    inherits(model, "clm") ~ "clm",
    inherits(model, "clm2") ~ "clm2",
    inherits(model, "polr") ~ "polr",
    inherits(model, c("rq", "rqss")) ~ "rq",
    inherits(model, "gee") ~ "gee",
    inherits(model, "plm") ~ "plm",
    inherits(model, "negbin") ~ "glm.nb",
    inherits(model, "vgam") ~ "vgam",
    inherits(model, "vglm") ~ "vglm",
    inherits(model, "glm") ~ "glm",
    inherits(model, "lm_robust") ~ "lm",
    inherits(model, "lmrob") ~ "lm",
    inherits(model, "lmRob") ~ "lm",
    inherits(model, "lm") ~ "lm",
    inherits(model, "betareg") ~ "betareg",
    inherits(model, "truncreg") ~ "truncreg",
    inherits(model, "coxph") ~ "coxph",
    inherits(model, "multinom") ~ "multinom",
    inherits(model, "Zelig-relogit") ~ "Zelig-relogit",
    inherits(model, "zerotrunc") ~ "zerotrunc",
    inherits(model, "zeroinfl") ~ "zeroinfl",
    inherits(model, "hurdle") ~ "hurdle",
    inherits(model, "MixMod") ~ "MixMod",
    TRUE ~ "generic"
  )
}
