% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis.R
\name{easy_remove_axes}
\alias{easy_remove_axes}
\alias{easy_remove_y_axis}
\alias{easy_remove_x_axis}
\title{Easily remove one or more axes}
\usage{
easy_remove_axes(which = c("both", "x", "y"), what = c("ticks",
  "title", "text", "line"), teach = FALSE)

easy_remove_y_axis(what = c("ticks", "title", "text", "line"),
  teach = FALSE)

easy_remove_x_axis(what = c("ticks", "title", "text", "line"),
  teach = FALSE)
}
\arguments{
\item{which}{which axis or axes to remove, by default "both"}

\item{what}{axis components to remove
(\code{"ticks"}, \code{"title"}, \code{"text"}, and/or \code{"line"})}

\item{teach}{print longer equivalent \code{\link[ggplot2]{ggplot2}}
expression?}
}
\value{
a \code{\link[ggplot2]{theme}} object  which can be used in
\code{\link[ggplot2]{ggplot2}} calls
}
\description{
easy_remove_axes by default removes both axes, but can remove only x or y
if "x" or "y" is given to the 'which' argument
}
\details{
easy_remove_x_axis and easy_remove_y_axis remove just the x or y axis,
respectively.
}
\examples{

library(ggplot2)
# Remove all axes
ggplot(mtcars, aes(wt, mpg)) +
  geom_point() + easy_remove_axes()

# remove just x axis
ggplot(mtcars, aes(wt, mpg)) +
  geom_point() + easy_remove_x_axis()

# can also use:
ggplot(mtcars, aes(wt, mpg)) +
  geom_point() + easy_remove_axes("x")

# Remove y axis
ggplot(mtcars, aes(wt, mpg)) +
  geom_point() + easy_remove_y_axis()

# Remove just the ticks
# Remove y axis
ggplot(mtcars, aes(wt, mpg)) +
  geom_point() + easy_remove_y_axis(what = "ticks")
}
\author{
Alicia Schep
}
