% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_continuous_asym.R
\name{continuous_scale_asym}
\alias{continuous_scale_asym}
\title{Continuous scale constructor for 'ggasym'}
\usage{
continuous_scale_asym(aesthetics, scale_name, palette, na.value, guide,
  ...)
}
\arguments{
\item{aesthetics}{The names of the aesthetics that this scale works with}

\item{scale_name}{The name of the scale}

\item{palette}{A palette function that when called with a numeric vector
with values between 0 and 1 returns the corresponding values in the
range the scale maps to.}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{A function used to create a guide or its name. See
\code{guides()} for more info.}

\item{...}{other input is passed on to \code{ggplot2::continuous_scale()};
see \code{?ggplot2::continuous_scale} for complete documentation}
}
\description{
This is a this wrapper around \code{continuous_scale()} from
    the 'ggplot2' package. It is generally best to call this function
    implicitly using one of the wrappers that have the general naming
    scheme of \code{scale_*_tl/br_*()} (such as
    \code{scale_fill_tl_gradient()}).
}
\examples{
library(tibble)
library(ggplot2)
tib <- tibble(g1 = c("A", "A", "B"),
              g2 = c("B", "C", "C"),
              val_1 = c(1, 2, 3),
              val_2 = c(-1, 0, 1))

tib

tib <- asymmetrise(tib, g1, g2)
ggplot(tib) +
geom_asymmat(aes(x = g1, y = g2, fill_tl = val_1, fill_br = val_2)) +
    scale_fill_tl_gradient(low = "lightpink", high = "tomato") +
    scale_fill_br_gradient(low = "lightblue1", high = "dodgerblue") +
    labs(fill_tl =  "top-left fill", fill_br = "bottom-right fill")

}
