% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross-link.R
\name{cross_link}
\alias{cross_link}
\title{Add a plot to connect selected observations}
\usage{
cross_link(
  link,
  data = waiver(),
  ...,
  on_top = TRUE,
  obs_size = 1,
  inherit_index = NULL,
  inherit_panel = NULL,
  inherit_nobs = NULL,
  size = NULL,
  active = NULL
)
}
\arguments{
\item{link}{A \code{\link[=link_draw]{link_draw()}} object that defines how to draw the links,
such as \code{\link[=link_line]{link_line()}}.}

\item{data}{The dataset to use for the layout. By default,
\code{\link[=fortify_matrix]{fortify_matrix()}} will convert the data to a matrix. This argument
allows you to change the layout data. If not specified, the original data
will be used.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
\code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{on_top}{A boolean value indicating whether to draw the link on top of
the plot panel (\code{TRUE}) or below (\code{FALSE}).}

\item{obs_size}{A single numeric value that indicates the size of a single
observation, ranging from \verb{(0, 1]}.}

\item{inherit_index}{A boolean value indicating whether to inherit the
ordering index. If \code{TRUE}, will match the layout ordering index with the
data names.}

\item{inherit_panel}{A boolean value indicating whether to inherit the
panel group. If \code{TRUE}, will match the layout panel with the data names.}

\item{inherit_nobs}{A boolean value indicating whether to inherit the
number of observations (nobs). If \code{TRUE}, the \code{data} input must be
compatible with the layout data.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
Add a plot to connect selected observations
}
\section{ggplot2 Specification}{

The \code{cross_link} function initializes a \code{ggplot} object but does not
initialize any data. Using \code{\link[=scheme_data]{scheme_data()}} to change the internal data if
needed.
}

