% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-quad-switch.R
\name{quad_switch}
\alias{quad_switch}
\alias{hmanno}
\title{Determine the Active Context of Quad-Layout}
\usage{
quad_switch(
  position = NULL,
  size = NULL,
  width = NULL,
  height = NULL,
  free_guides = waiver(),
  what = waiver()
)

hmanno(
  position = NULL,
  size = NULL,
  width = NULL,
  height = NULL,
  free_guides = waiver(),
  what = waiver(),
  ...,
  guides = deprecated(),
  free_spaces = deprecated(),
  plot_data = deprecated(),
  theme = deprecated(),
  free_labs = deprecated()
)
}
\arguments{
\item{position}{A string of \code{"top"}, \code{"left"}, \code{"bottom"}, or \code{"right"} indicates which annotation stack should be activated. If \code{NULL}, it sets the
active context to the \code{\link[=quad_layout]{quad_layout()}}/\code{\link[=ggheatmap]{ggheatmap()}} itself.}

\item{size}{A numeric value or an \code{\link[grid:unit]{unit}} object to set the
total \code{height}/\code{width} of the annotation stack.
\itemize{
\item If \code{position} is \code{"top"} or \code{"bottom"}, \code{size} sets the total height of
the annotation.
\item If \code{position} is \code{"left"} or \code{"right"}, \code{size} sets the total width of the
annotation.
}}

\item{width, height}{The relative width/height of the main plot, can be a
\code{\link[grid:unit]{unit}} object.}

\item{free_guides}{Override the \code{guides} collection behavior specified in the
\code{\link[=quad_layout]{quad_layout()}}/\code{\link[=ggheatmap]{ggheatmap()}} for the annotation stack.}

\item{what}{What should get activated in the annotation stack?
A single number or string of the plot elements in the stack layout. If \code{NULL}, will remove any active context.}

\item{...}{These dots are for future extensions and must be empty.}

\item{guides}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}

\item{free_spaces}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}

\item{plot_data}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_data]{plot_data()}} function instead.}

\item{theme}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_theme]{plot_theme()}} function instead.}

\item{free_labs}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}
}
\value{
An object that can be added to \code{\link[=quad_layout]{quad_layout()}}/\code{\link[=ggheatmap]{ggheatmap()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{quad_switch()} integrates \code{\link[=quad_active]{quad_active()}} and \code{\link[=quad_anno]{quad_anno()}} into one
function for ease of use. This function allows you to quickly change the
active context of the \code{\link[=quad_layout]{quad_layout()}} and its annotations.

\code{hmanno} is an alias for \code{quad_switch}, with additional arguments for
backward compatibility
}
\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top() +
    align_dendro()
}
\seealso{
\itemize{
\item \code{\link[=quad_active]{quad_active()}}/\code{\link[=quad_anno]{quad_anno()}}
\item \code{\link[=quad_init]{quad_init()}}
}
}
