% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activate.R
\name{stack_active}
\alias{stack_active}
\title{Determine the active context of stack layout}
\usage{
stack_active(
  sizes = NULL,
  guides = NA,
  free_labs = NA,
  free_spaces = NA,
  plot_data = NA,
  theme = NULL,
  what = NULL
)
}
\arguments{
\item{sizes}{A numeric or \link[grid:unit]{unit} object of length \code{3} indicates
the relative widths (\code{direction = "horizontal"}) / heights (\code{direction = "vertical"}).}

\item{guides}{A boolean value or a string containing one or more of
\code{"t"},\code{"l"},\code{"b"},and \code{"r"} indicates Which guide should be collected. If \code{NULL}, no
guides will be collected. Default: "tlbr".}

\item{free_labs}{A boolean value or a string containing one or more of
\code{"t"},\code{"l"},\code{"b"},and \code{"r"} indicates which axis title should be free from
alignment. If \code{NULL}, all axis title will be aligned. Default: "tlbr".}

\item{free_spaces}{A character specifies the ggplot elements which won't
count space sizes when alignment. If \code{NULL} (default), no space will be
removed. See \code{\link[=free_space]{free_space()}} for allowed values.}

\item{plot_data}{A function used to transform the plot data before rendering.
By default, it'll inherit from the parent layout. If no parent layout, the
default is to not modify the data. Use \code{NULL}, if you don't want to modify
anything.

Used to modify the data after layout has been created, but before the data is
handled of to the ggplot2 for rendering. Use this hook if the you needs
change the default data for all \code{geoms}.}

\item{theme}{A \link[ggplot2:theme]{theme()} object to rendering the guides, title, subtitle, caption, margins and background. Only used when position is \code{NULL}.}

\item{what}{What should get activated for the stack layout? Possible values
are follows:
\itemize{
\item A single number or string of the plot elements in the stack layout.
Usually you are waive to use this, since the adding procedure can be
easily changed.
\item \code{NULL}: Remove any active context, this is useful when the active
context is a \code{\link[=layout_heatmap]{layout_heatmap()}} object, where any \code{Align} objects will
be added into the heatmap. By removing the active context, we can add
\code{Align} object into the \code{\link[=layout_stack]{layout_stack()}} .
}}
}
\value{
A \code{stack_active} object which can be added into
\link[=layout_stack]{StackLayout}.
}
\description{
Determine the active context of stack layout
}
\examples{
ggstack(matrix(1:9, nrow = 3L)) +
    ggheatmap() +
    # ggheamtap will set the active context, directing following addition
    # into the heatmap plot area. To remove the heatmap active context,
    # we can use `stack_active()` which will direct subsequent addition into
    # the stack
    stack_active() +
    # here we add a dendrogram to the stack.
    align_dendro()
}
