% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-free-align.R,
%   R/alignpatch-free-border.R, R/alignpatch-free-lab.R,
%   R/alignpatch-free-space.R
\name{free_align}
\alias{free_align}
\alias{free_border}
\alias{free_lab}
\alias{free_space}
\title{Free from alignment}
\usage{
free_align(plot, axes = "tlbr")

free_border(plot, borders = "tlbr")

free_lab(plot, labs = "tlbr")

free_space(plot, ...)
}
\arguments{
\item{plot}{A \link[ggplot2:ggplot]{ggplot} or \link[=align_plots]{alignpatches}
object.}

\item{axes}{Which axes shouldn't be aligned? A string containing
one or more of \code{"t"},\code{"l"},\code{"b"},and \code{"r"}.}

\item{borders}{Which border shouldn't be aligned? A string containing
one or more of \code{"t"},\code{"l"},\code{"b"},and \code{"r"}.}

\item{labs}{Which axis labs to be free? A string containing one or more of
\code{"t"},\code{"l"},\code{"b"},and \code{"r"}.}

\item{...}{What sizes of the ggplot2 elements to remove? Allowed values are:
\code{"title"}, \code{"subtitle"}, \code{"xlab-t"}, \code{"axis-t"}, \code{"strip-t"},
\code{"patch-title-top"}, \code{"margin-t"}, \code{"ylab-l"}, \code{"axis-l"}, \code{"strip-l"},
\code{"patch-title-left"}, \code{"margin-l"}, \code{"caption"}, \code{"xlab-b"}, \code{"axis-b"},
\code{"strip-b"}, \code{"patch-title-bottom"}, \code{"margin-b"}, \code{"ylab-r"}, \code{"axis-r"},
\code{"strip-r"}, \code{"patch-title-right"}, and \code{"margin-r"}. Some unions also
allowed:
\itemize{
\item \verb{"t"/"top}: "title", "subtitle", "xlab-t", "axis-t", "strip-t",
"patch-title-top", "margin-t".
\item \code{"l"/"left"}: "ylab-l", "axis-l", "strip-l", "patch-title-left",
"margin-l".
\item \code{"b"/"bottom"}: "caption", "xlab-b", "axis-b", "strip-b",
"patch-title-bottom", "margin-b".
\item \code{"r"/"right"}: "ylab-r", "axis-r", "strip-r", "patch-title-right",
"margin-r".
\item \code{"x"}: "xlab-t", "axis-t", "strip-t", "xlab-b", "axis-b", "strip-b".
\item \code{"y"}: "ylab-l", "axis-l", "strip-l", "ylab-r", "axis-r", "strip-r".
\item \code{"xlab"/"xlabs"}: "xlab-t", "xlab-b".
\item \code{"ylab"/"ylabs"}: "ylab-l", "ylab-r".
\item \code{"lab"/"labs"}: "xlab-t", "xlab-b", "ylab-l", "ylab-r".
\item \code{"axis"/"axes"}: "axis-t", "axis-b", "axis-l", "axis-r".
\item \code{"strip"/"strips"}: "strip-t", "strip-b", "strip-l", "strip-r".
\item \code{"patch-title"}/\code{"patch-titles"}: "patch-title-top", "patch-title-left",
"patch-title-bottom", "patch-title-right".
\item \code{"margin"}/\code{"margins"}: "margin-t", "margin-l", "margin-b", "margin-r".
}}
}
\value{
\itemize{
\item \code{free_align}: A modified version of \code{plot} with a \code{free_align} class.
}

\itemize{
\item \code{free_border}: A modified version of \code{plot} with a \code{free_border} class.
}

\itemize{
\item \code{free_lab}: A modified version of \code{plot} with a \code{free_lab} class.
}

\itemize{
\item \code{free_space}: A modified version of \code{plot} with a \code{free_space} class.
}
}
\description{
\link{align_plots} will try to align plot panels, and every elements of the plot,
following functions romove these restrictions:
\itemize{
\item \code{free_align}: if we want to compose plots without alignment of some panel
axes (panel won't be aligned). we can wrap the plot with \code{free_align}.
\item \code{free_border}: If we want to compose plots without alignment of the panel
borders (but still align the panels themselves), we can wrap the plot with
\code{free_border}.
\item \code{free_lab}: If we want to compose plots without alignment of the axis
title, we can wrap the plot with \code{free_lab}.
\item \code{free_space}: Removing the ggplot element sizes when aligning.
}
}
\examples{
# directly copied from patchwork
# Sometimes you have a plot that defies good composition alginment, e.g. due
# to long axis labels
p1 <- ggplot(mtcars) +
    geom_bar(aes(y = factor(gear), fill = factor(gear))) +
    scale_y_discrete(
        "",
        labels = c(
            "3 gears are often enough",
            "But, you know, 4 is a nice number",
            "I would def go with 5 gears in a modern car"
        )
    )

# When combined with other plots it ends up looking bad
p2 <- ggplot(mtcars) +
    geom_point(aes(mpg, disp))

align_plots(p1, p2, ncol = 1L)

# We can fix this be using free (here, with the default "panel" type)
align_plots(free_align(p1), p2, ncol = 1L)

# If we still want the panels to be aligned to the right, we can choose to
# free only the left side
align_plots(free_align(p1, axes = "l"), p2, ncol = 1L)

# We could use "label" to fix the layout in a different way
align_plots(p1, free_lab(p2), ncol = 1L)

# Another issue is that long labels are not using already available free
# space.
align_plots(NULL, p1, p2, p2)

# This can be fixed with the "space" type
align_plots(NULL, free_space(p1, "l"), p2, p2)

}
