% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualise_many_sequences.R
\name{extract_and_sort_sequences}
\alias{extract_and_sort_sequences}
\title{Extract, sort, and add spacers between sequences in a dataframe}
\usage{
extract_and_sort_sequences(
  sequence_dataframe,
  sequence_variable = "sequence",
  grouping_levels = c(family = 8, individual = 2),
  sort_by = "sequence_length",
  desc_sort = TRUE
)
}
\arguments{
\item{sequence_dataframe}{\code{dataframe}. A dataframe containing the sequence information and all required meta-data. See \code{\link{example_many_sequences}} for an example of a compatible dataframe.}

\item{sequence_variable}{\code{character}. The name of the column within the dataframe containing the sequence information to be output. Defaults to \code{"sequence"}.}

\item{grouping_levels}{\verb{named character vector}. What variables should be used to define the groups/chunks, and how large a gap should be left between groups at that level. Set to \code{NA} to turn off grouping.\cr\cr Defaults to \code{c("family" = 8, "individual" = 2)}, meaning the highest-level groups are defined by the \code{family} column, and there is a gap of 8 between each family. Likewise the second-level groups (within each family) are defined by the \code{individual} column, and there is a gap of 2 between each individual.\cr\cr Any number of grouping variables and gaps can be given, as long as each grouping variable is a column within the dataframe. It is recommended that lower-level groups are more granular and subdivide higher-level groups (e.g. first divide into families, then into individuals within families). \cr\cr To change the order of groups within a level, make that column a factor with the order specified e.g. \code{example_many_sequences$family <- factor(example_many_sequences$family, levels = c("Family 2", "Family 3", "Family 1"))} to change the order to Family 2, Family 3, Family 1.}

\item{sort_by}{\code{character}. The name of the column within the dataframe that should be used to sort/order the rows within each lowest-level group. Set to \code{NA} to turn off sorting within groups.\cr\cr Recommended to be the length of the sequence information, as is the case for the default \code{"sequence_length"} which was generated via \code{example_many_sequences$sequence_length <- nchar(example_many_sequences$sequence)}.}

\item{desc_sort}{\code{logical}. Boolean specifying whether rows within groups should be sorted by the \code{sort_by} variable descending (\code{TRUE}, default) or ascending (\code{FALSE}).}
}
\value{
\verb{character vector}. The sequences ordered and grouped as specified, with blank sequences (\code{""}) inserted as spacers as specified.
}
\description{
This function takes a dataframe that contains sequences and metadata,
recursively splits it into multiple levels of groups defined by \code{grouping_levels},
and adds breaks between each level of group as defined by \code{grouping_levels}.
Within each lowest-level group, reads are sorted by \code{sort_by}, with order determined
by \code{desc_sort}. \cr\cr Default values are set up to work with the included dataset
\code{\link{example_many_sequences}}. \cr\cr The returned sequences vector is ideal input for
\code{\link[=visualise_many_sequences]{visualise_many_sequences()}}.\cr\cr Also called by \code{\link[=extract_methylation_from_dataframe]{extract_methylation_from_dataframe()}}
to produce input for \code{\link[=visualise_methylation]{visualise_methylation()}}.
}
\examples{
extract_and_sort_sequences(
    example_many_sequences,
    sequence_variable = "sequence",
    grouping_levels = c("family" = 8, "individual" = 2),
    sort_by = "sequence_length",
    desc_sort = TRUE
)

extract_and_sort_sequences(
    example_many_sequences,
    sequence_variable = "sequence",
    grouping_levels = c("family" = 3),
    sort_by = "sequence_length",
    desc_sort = FALSE
)

extract_and_sort_sequences(
    example_many_sequences,
    sequence_variable = "sequence",
    grouping_levels = NA,
    sort_by = "sequence_length",
    desc_sort = TRUE
)

extract_and_sort_sequences(
    example_many_sequences,
    sequence_variable = "sequence",
    grouping_levels = c("family" = 8, "individual" = 2),
    sort_by = NA
)

extract_and_sort_sequences(
    example_many_sequences,
    sequence_variable = "sequence",
    grouping_levels = NA,
    sort_by = NA
)

extract_and_sort_sequences(
    example_many_sequences,
    sequence_variable = "quality",
    grouping_levels = c("individual" = 3),
    sort_by = "quality",
    desc_sort = FALSE
)

}
