% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_methylation_from_fastq.R
\name{convert_MM_vector_to_locations}
\alias{convert_MM_vector_to_locations}
\title{Convert MM tag to absolute index locations (\code{\link[=read_modified_fastq]{read_modified_fastq()}} helper)}
\usage{
convert_MM_vector_to_locations(sequence, skips, target_base = "C")
}
\arguments{
\item{sequence}{\code{character}. The DNA sequence about which the methylation information is being processed.}

\item{skips}{\verb{integer vector}. A component of a SAM MM tag, representing the number of skipped target bases in between each assessed base.}

\item{target_base}{\code{character}. The base type that has been assessed or skipped (defaults to \code{"C"}).}
}
\value{
\verb{integer vector}. All of the base indices at which methylation/modification information was processed. Will all be instances of the target base.
}
\description{
This function takes a sequence, a SAM-style vector of number of potential
target bases to skip in between each target base that was actually assessed,
and a target base type (defaults to \code{"C"} as 5-methylcytosine is most common).\cr\cr
It identifies the indices/locations of all instances of the target base within the
sequence, and then goes along the vector of these indices, skipping them if requested
by \code{skips}.\cr\cr
For example, the sequence \code{"GGCGGCGGCGGC"} with target \code{"C"} and skips \code{c(0, 0, 1)}
would identify that the indices where \code{"C"} occurs are \code{c(3, 6, 9, 12)}. It would then
take the first index, the second index, skip one, and take the fourth index i.e.
return \code{c(3, 6, 12)}. If instead the skips were given as \code{c(0, 2)} it would take the
first index, skip two, and take the fourth index i.e. return \code{c(3, 12)}. If the skips
were given as \code{c(1, 1)} it would skip one, take the second index, skip one, and take
the fourth index i.e. return \code{c(6, 12)}. \cr\cr
The length of \code{skips} corresponds to the number of indices/locations that will be returned
(i.e. the length of the returned locations vector).\cr\cr
Ideally the length of \code{skips} plus the sum of \code{skips} (i.e. the number returned plus the
total number skipped) is the same or less than the number of possible locations. If it is
the same, then the last possible location will be taken; if it is less then some number of
possible locations at the end will be skipped.\cr\cr
\strong{Important:} if the length of \code{skips} plus the sum of \code{skips} is greater than the number
of possible locations (instances of the target base within the sequence), then the total
number of taken or skipped locations will be greater than the number of available locations.
In this case, the returned vector will contain NA after the available locations have run out.
In the example above, \code{skips = c(0, 0, 0, 0, 0)} would return \code{c(3, 6, 9, 12, NA)}, and
\code{skips = c(0, 2, 0)} would return \code{c(3, 12, NA)}.\cr\cr
Therefore, if the target base is totally absent from the sequence (e.g. target \code{"A"} in
\code{"GGCGGCGGCGGC"}), then any non-zero length of \code{skips} will return the same length of \code{NA}s e.g.
\code{skips = c(0)} would return \code{NA}, and \code{skips = c(0, 1, 0)} would return \code{c(NA, NA, NA)}.\cr\cr
If \code{skips} has length zero, it will return \code{numeric(0)}.\cr\cr
This function is reversed by \code{\link[=convert_locations_to_MM_vector]{convert_locations_to_MM_vector()}}.
}
\examples{
convert_MM_vector_to_locations(
    "GGCGGCGGCGGC",
    skips = c(0, 0, 0, 0),
    target_base = "C"
)

convert_MM_vector_to_locations(
    "GGCGGCGGCGGC",
    skips = c(1, 1, 1, 1),
    target_base = "G"
)

convert_MM_vector_to_locations(
    "GGCGGCGGCGGC",
    skips = c(0, 0, 2, 1, 0),
    target_base = "G"
)

}
