% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopQ.R
\name{loopQ3}
\alias{loopQ3}
\title{loopQ3}
\usage{
loopQ3(map, disp = 1, step = 0.075, minSize = 0.012, minSizeNG = 0.001,
  QUIET = F)
}
\arguments{
\item{map}{object returned by function genMa}

\item{disp}{0: no info, 1: some info, 2: detailed info}

\item{step}{loop increment}

\item{minSize}{zone area threshold under which a zone is too small to be manageable}

\item{minSizeNG}{zone area threshold under which a zone will be removed}

\item{QUIET}{run in silence-no display}
}
\value{
a matrix with 8 columns and as many rows as loop elements. Columns contain the following values calculated for each quantile vector:  criterion, cost, cost per label, number of zones, quantile associated probability values and number of non degenerated quantiles.
}
\description{
loopQ3
}
\details{
exploratory loop on probability values associated to quantiles. Performs map zonings for each value of the 3 quantile loop (yielding a 4-label zoning).
see also \code{\link{loopQ1}}, \code{\link{loopQ2}}, \code{\link{loopQ4}}, \code{\link{loopQ5}} for loops with a different number of labels
}
\examples{
\donttest{
# not run, take a while - >5s CPU
seed=10
map=genMap(DataObj=NULL,seed=seed,disp=FALSE,krig=1)
loopQ3(map,step=0.1,disp=0,QUIET=TRUE)
}
}
