% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_query_run_geoquery.R
\name{run_geoquery}
\alias{run_geoquery}
\alias{run_geoquery.dimensional_query}
\title{Get a geographic vector from a query}
\usage{
run_geoquery(
  dq,
  unify_by_grain = TRUE,
  fact = NULL,
  dimension = NULL,
  attribute = NULL
)

\method{run_geoquery}{dimensional_query}(
  dq,
  unify_by_grain = TRUE,
  fact = NULL,
  dimension = NULL,
  attribute = NULL
)
}
\arguments{
\item{dq}{A \code{dimensional_query} object.}

\item{unify_by_grain}{A boolean, unify facts with the same grain.}

\item{fact}{A string, name of the fact.}

\item{dimension}{A string, name of the geographic dimension.}

\item{attribute}{A string, name of the geographic attribute to consider.}
}
\value{
A \code{sf} object.
}
\description{
After defining a query and geographic dimensions, run the query and select
the geographic data associated with it to get a geographic data layer as the
result.
}
\details{
In the case of having several fact tables, as an option, we can indicate if
we do not want to unify the facts in the case of having the same grain.

If the result only has one fact table, it is not necessary to provide its
name. Nor is it necessary to indicate the name of the geographic dimension if
there is only one available.

If no attribute is specified, the geographic attribute of the result with
finer granularity is selected.
}
\examples{
library(tidyr)
library(starschemar)
library(sf)

gms <- geomultistar(ms = ms_mrs, geodimension = "where") \%>\%
  define_geoattribute(
    attribute = "city",
    from_layer = usa_cities,
    by = c("city" = "city", "state" = "state")
  )  \%>\%
  define_geoattribute(
    attribute = "state",
    from_layer = usa_states,
    by = c("state" = "state")
  ) \%>\%
  define_geoattribute(attribute = "region",
                      from_attribute = "state") \%>\%
  define_geoattribute(attribute = "all_where",
                      from_layer = usa_nation)

gdq <- dimensional_query(gms) \%>\%
  select_dimension(name = "where",
                   attributes = c("state", "city")) \%>\%
  select_dimension(name = "when",
                   attributes = c("when_happened_year", "when_happened_week")) \%>\%
  select_fact(
    name = "mrs_age",
    measures = c("n_deaths")
  ) \%>\%
  select_fact(name = "mrs_cause",
              measures = c("pneumonia_and_influenza_deaths", "other_deaths")) \%>\%
  filter_dimension(name = "when", when_happened_week <= "03") \%>\%
  filter_dimension(name = "where", state == "MA")

sf <- gdq \%>\%
  run_geoquery()

}
\seealso{


Other geo functions: 
\code{\link{define_geoattribute}()},
\code{\link{geomultistar}()},
\code{\link{get_empty_geoinstances}()}
}
\concept{geo functions}
