% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.morphologika.r
\name{read.morphologika}
\alias{read.morphologika}
\title{Read landmark data from Morphologika file(s)}
\usage{
read.morphologika(filelist)
}
\arguments{
\item{filelist}{The name of a Morphologika *.txt file containing two- or three-dimensional landmark data.
Alternatively, a character vector of names of Morphologika *.txt file (such as made using \code{\link{list.files}})}
}
\value{
Function returns a (p x k x n) array of the coordinate data. If other optional headers are present in
the file (e.g. "[labels]" or "[wireframe]") function returns a list containing the "coords" array, 
and data matrix of "labels" and or "wireframe".
}
\description{
Read Morphologika file (*.txt) to obtain landmark coordinates and specimen information
}
\details{
This function reads a *.txt file in the Morphologika format containing two- or three-dimensional 
 landmark coordinates. Morphologika files are text files in one of the standard formats for 
 geometric morphometrics (see O'Higgins and Jones 1998,2006). If multiple morphologika files 
 are specified (containing the same number of landmarks for all specimens), function returns a single object for files.

If the headers "[labels]", "[labelvalues]" and "[groups]" are present, then a data matrix containing all 
 individual specimen information is returned.
 If the header "[wireframe]" is present, then a matrix of the landmark addresses for the wireframe is
 returned (see \code{\link{plotRefToTarget}} option 'links'). 
 If the header "[polygon]" is present, then a matrix of the landmark addresses for the polygon wireframe is returned (see \code{\link[rgl]{polygon3d}} or \code{\link[graphics]{polygon}}). 
 
 NOTE: For multiple morphologika files that each contain only a single specimen (such as those exported from
 Stratovan Checkpoint software), one can add specimen names to 
 the returned 3D array by: dimnames(mydata)[[3]] <- gsub (".txt", "", filelist)).
}
\references{
O'Higgins P and Jones N (1998) Facial growth in Cercocebus torquatus: An application of three 
dimensional geometric morphometric techniques to the study of morphological  variation. Journal of Anatomy. 
193: 251-272

O'Higgins P and Jones N (2006) Tools for statistical shape analysis. Hull York Medical School.
}
\author{
Emma Sherratt & Erik Otarola-Castillo
}
\keyword{IO}
