% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{lesmis}
\alias{lesmis}
\title{Coappearance network of characters in Les Miserables (undirected)}
\format{A list of two data frames:
\itemize{
\item the edges data set consists of three variables of length 254:
\itemize{
  \item from: Character 1
  \item to: Character 2
  \item degree: number of times they appear together in a chapter of Les Miserables
}
\item the vertices data set consists of two variables with information on 77 characters:
\itemize{
  \item id: Character ID number
  \item label: Character name
}
}}
\usage{
lesmis
}
\description{
A list of two datasets, vertices and edges, containing data on characters and their coapperance in chapters in Victor Hugo's Les Miserables.
The variables are as follows:
}
\examples{
# prep the data
lesmisnet <- merge(lesmis$edges, lesmis$vertices, by.x = "from",
                   by.y = "label", all = TRUE)
lesmisnet$degree[is.na(lesmisnet$degree)] <- 0

# create plot
library(geomnet)
library(dplyr)

ggplot(data = lesmisnet, aes(from_id = from, to_id = to,
                             linewidth = degree / 5 + 0.1 )) +
  geom_net(aes(size = degree, alpha = degree),
           colour = "grey30", ecolour = "grey60",
           layout.alg = "fruchtermanreingold", labelon = TRUE, vjust = -0.75) +
  scale_alpha(range = c(0.3, 1)) +
  theme_net()
}
\references{
D. E. Knuth, The Stanford GraphBase: A Platform for Combinatorial Computing, Addison-Wesley, Reading, MA (1993).
}
\keyword{datasets}

