% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwr_geoc.R
\name{gwr_geoc}
\alias{gwr_geoc}
\title{geographical complexity-geographically weighted regression}
\usage{
gwr_geoc(
  formula,
  data,
  gcs = NULL,
  alpha = seq(0.05, 1, 0.05),
  bw = "RMSE",
  adaptive = TRUE,
  kernel = "gaussian"
)
}
\arguments{
\item{formula}{A formula of \code{GCGWR} model.}

\item{data}{An \code{sf} object or spatial vector object that can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{gcs}{(optional) The geocomplexity matrix corresponding to each variable, which is calculated
by default using \code{geocd_vector()}.}

\item{alpha}{(optional) Balancing the weights of attribute similarity matrix and geographic distance matrix.}

\item{bw}{(optional) The bandwidth used in selecting models. The optimal bandwidth can be selected using one
of three methods: \code{RMSE}, \code{AIC}, and \code{AICc}. Default will use \code{RMSE}.}

\item{adaptive}{(optional) Whether the bandwidth value is adaptive or not. Default is \code{TRUE}.}

\item{kernel}{(optional) Kernel function. Default is \code{gaussian}.}
}
\value{
A list with GCGWR results.
\describe{
\item{\code{SDF}}{an sf tibble with coefficients, standard errors and t values}
\item{\code{diagnostic}}{goodness of fit indicators}
\item{\code{args}}{some key parameters}
}
}
\description{
geographical complexity-geographically weighted regression
}
\examples{
\donttest{
## The following code takes a long time to run:
econineq = sf::read_sf(system.file('extdata/econineq.gpkg',package = 'geocomplexity'))
g = gwr_geoc(formula = Gini ~ ., data = econineq,
             alpha = 0.5, bw = "AIC", adaptive = TRUE)
g
}
}
