\name{pre8.split.train.test}
\Rdversion{1.1}
\alias{pre8.split.train.test}
\title{
        Split dataset into TRAIN and TEST files
}
\description{
        Splits the data file named \code{\var{file.name}} in \code{\var{dir.file}}, into TRAIN and TEST files, based on the percentage \code{\var{train.percent}} - how many percent of the data should go into TRAIN file.
}
\usage{
pre8.split.train.test(file.name, dir.file, dir.out, train.percent = 80, 
separ = "\t", index.prefix = "index", file.has.ext = TRUE, resample = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{file.name}{
        The  name of the geno file. This file is expected to have the disease status as its last column (1 for CASE and 0 for CONTROL).
}
  \item{dir.file}{
        The name of directory where \code{\var{file.name}} can be found.
}
  \item{dir.out}{
        The name of directory into which the TRAIN and TEST output files should go.
}
  \item{train.percent}{
        The pecentage (0 to 100) of what portion of data (rows) should go into the TRAIN file; the rest will be in TEST file. Ex: for 1000 entries, if \code{\var{train.percent=80}}, then 800 entries will appear in <file.name>.test, and 200 entries will go into <file.name>.train.
}
  \item{separ}{
        The separator used in the \code{\var{file.name}} to separate entries.
}
  \item{index.prefix}{
        The name of the index file to use for the separation of train from test entries. This file may already exist in \code{\var{dir.out}} (if it has been created by previous runs of this program).
}
  \item{file.has.ext}{
        Flag whether or not \code{\var{file.name}} has a filename extension (ex. ".txt", ".ped", ".mlgeno").
}
  \item{resample}{
        Additional file beginning with the name \code{\var{index.prefix}} will be saved in the \code{\var{dir.out}} directory for the given \code{\var{train.percent}}. This file will contain indices that correspond to entries taken into the TRAIN file. If \code{\var{resample}}=FALSE, then all subsequent runs of this function on other files (for example for different chromosomes on the same dataset) with the same \code{\var{train.percent}} will use that saved file. This is to make sure that the same individuals go into TRAIN file, across all chromosomes. If \code{\var{resample}}=TRUE, then new random resampling will take place and new index file will be generated and saved to the \code{\var{dir.out}} directory; note, in this case the entries generated by this file will no longer correspond to entries generated by previous runs for previous index files; so for consistency, re-run all chromosomes with resample flag set to FALSE.

}
}
\details{

Splits the data file named \code{\var{file.name}} in \code{\var{dir.file}}, into TRAIN and TEST files, based on the percentage \code{\var{train.percent}} - how many percent of the data should go into TRAIN file. 


The file \code{\var{file.name}} is expected to have last column represent CASE and CONTROL; this is necessary to make sure that \code{\var{train.percent}} of CASE and \code{\var{train.percent}} of CONTROL entries go into TRAIN file, to have even sample of both types of entries. If the data is saved in many files (for example one file per chromosome), this function is designed to first randomly sample the individuals for the TRAIN file for the first file it is run on. Then it uses this sampling for all other chromosomes on subsequent runs (if resample=FALSE), such that individuals in TRAIN file correspond to one another across all chromosome files (same holds for TEST files). The index file is also useful for processing familyl .fam file after the data has been split.


The following files will be output:
\preformatted{
 - <file.name>.train.<train.percent>.<ext> - the output TRAIN file containing 
      train.percent percent of the original data; 
      will appear in dir.out directory.
      * <file.name> here is the name without extension;
      * <ext> is the extension part of <file.name> (i.e. the section that 
          follows the last "." symbol)
      * <train.percent> is specifying the percentage that was used to generate 
          the file.
 - <file.name>.test.<train.percent>.<ext> - the entries for TEST file, containing
      the remaining (100 - train.percent) data. Similar to the TRAIN file above.
 - <index.prefix>.<train.percent>.txt - the file containing indicies of the 
      entries corresponding to TRAIN file, this file will be generated if it 
      does not already exist in dir.out, or if resample=TRUE.
}


}
\value{
\item{out$train}{The FULL name of the output TRAIN file}
\item{out$test}{The FULL name of the output TEST file}
}
\author{
Olia Vesselova
}

\seealso{
\code{\link{pre6.merge.genos}}, \code{\link{pre7.add.conf.var}}, 
\code{\link{pre8.split.train.test.batch}}
}
\examples{
print("See the demo 'gendemo'.")
}
