# Arm-level effect estimate (given a one-row data frame)
# Returns mean, standard deviation.
mtc.arm.mle.binom.logit <- function(data) {
    s <- data['responders'] + 0.5
    f <- data['sampleSize'] - s + 1
    x <- c('mean'=as.numeric(log(s/f)), 'sd'=as.numeric(sqrt(1/s + 1/f)))
}

# Relative effect estimate (given a two-row data frame)
mtc.rel.mle.binom.logit <- function(data) {
    e1 <- mtc.arm.mle.binom.logit(data[1,])
    e2 <- mtc.arm.mle.binom.logit(data[2,])
    c(e2['mean'] - e1['mean'], sqrt(e1['sd']^2 + e2['sd']^2))
}

mtc.code.likelihood.binom.logit <- function() {
"r[i, k] ~ dbin(p[i, k], n[i, k])
logit(p[i, k]) <- mu[i] + delta[i, k]"
}

scale.log.binom.logit <- function() { TRUE }
scale.name.binom.logit <- function() { "Odds Ratio" }

# Initial values outside this range result in probability 0 or 1 for the
# binomial, which may lead to BUGS/JAGS rejecting the data
scale.limit.inits.binom.logit <- function() {
	c(-745, 36.8)
}
