% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbp3d_cpp_rd.r
\docType{class}
\name{gbp3d}
\alias{Rcpp_gbp3d}
\alias{Rcpp_gbp3d-class}
\alias{gbp3d}
\title{gbp3d}
\format{An object of class \code{C++Class} of length 1.}
\usage{
gbp3d
}
\description{
generalized bin packing problem in 3 dimension, a.k.a bin packing problem.
}
\details{
gbp3d init a profit vector p, a length vector l, a depth vector d, a height vector h, and also
  a length constraint ml, a depth constraint md, and a height constraint mh on l x d x h cuboid
  with geometry intepretation.

 gbp3d solver would solve

   maximize   sum_{j=1}^{n} p_{j} k_{j}

   subject to fit (l_{j}, d_{j}, h_{j}) at coordinate (x_{j}, y_{j}, z_{j})
              such that no overlap in ml x md x mh cuboid, j = 1, ......, n

 and instantiate a gbp3d object with a x-axis coordinate vector x, a y-axis coordinate vector y,
  a z-axis coordinate vector z, a selection vector k, and an objective o.

 a gbp3d class instance has 6 fields:

  - p: profit of it fit into bn <vector>

       created via cluster max(l, d, h) and area via gbp3d_solver_dpp_main_create_p()

  - it: it position and scale <matrix>

    - x, y, z it position in the bin <numeric>

    - l, d, h it scale along x, y, z <numeric>

  - bn: bn scale <vector>

    - l, d, h bn scale along x, y, z <numeric>

  - k: selection indicator 0, 1 <vector>

  - o: objective achivement volumn fit in over volumn overall <numeric>

  - ok: a quick indicator of all it fit into bn? <bool>
}
\note{
p is a proxy of ranking on cuboid fit difficulty, often a func of max(l, d, h), surface, volume
  and solver would often maximize sum_{j=1}^{n} v_{j} k_{j} instead of sum_{j=1}^{n} p_{j} k_{j}
}
\seealso{
Other gbp3d: \code{\link{gbp3d_checkr}},
  \code{\link{gbp3d_solver_dpp}}
}
\keyword{datasets}

