% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_static_feeds.R
\name{get_system_calendar}
\alias{get_system_calendar}
\title{Grab the system_calendar feed.}
\usage{
get_system_calendar(
  city,
  directory = NULL,
  file = "system_calendar.rds",
  output = NULL
)
}
\arguments{
\item{city}{A character string that can be matched to a city or a url to an active 
gbfs .json feed. See [get_gbfs_cities()]  for a current list of available cities.}

\item{directory}{Optional. Path to a folder (or folder to be 
created) where the feed will be saved.}

\item{file}{Optional. The name of the file to be saved (if \code{output} 
is set to \code{"save"} or \code{"both"}), as a character string. 
Must end in \code{".rds"}.}

\item{output}{Optional. The type of output method. If left as default, this
argument is inferred from the \code{directory} argument. If 
\code{output = "save"}, the object will be saved as an .rds object at 
# the given path. If \code{output = "return"}, the output will be returned 
as a dataframe object. Setting \code{output = "both"} will do both.}
}
\value{
The output of this function depends on argument to \code{output}
and \code{directory}. Either a saved .rds object generated from the current 
feed, a dataframe object, or both.
}
\description{
\code{get_system_calendar} grabs and tidies the system_calendar feed 
for a given city. Metadata for this dataset can be found at: 
\url{https://github.com/NABSA/gbfs/blob/master/gbfs.md}
}
\examples{
# grab the system calendar feed for portland, oregon
\donttest{get_system_calendar(city = 
"http://biketownpdx.socialbicycles.com/opendata/system_calendar.json",  
                    directory = tempdir())}


}
\seealso{
[get_gbfs()] for a wrapper to call each of the \code{get_feed}
functions, [get_gbfs_cities()] for a dataframe of cities releasing gbfs
functions, and [get_which_gbfs_feeds()] for a dataframe of which feeds
are released by a given city.
}
