% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin_points.R
\name{thin_points}
\alias{thin_points}
\title{Spatial Correction - Spatially thin records}
\usage{
thin_points(
  df,
  accepted.name = NA,
  distance = 5,
  reps = 100,
  latitude = "latitude",
  longitude = "longitude"
)
}
\arguments{
\item{df}{Data frame of occurrence records.}

\item{accepted.name}{Accepted name of your species. This argument is not required
if the data frame already contains an accepted_name column.}

\item{distance}{Default = 5. Distance in km to separate records.}

\item{reps}{Default = 100. Number of times to perform thinning algorithm.}

\item{latitude}{Default = "latitude". The name of the latitude column in the data frame.}

\item{longitude}{Default = "longitude". The name of the longitude column in the data frame.}
}
\value{
df is a data frame with the cleaned data.
}
\description{
The \code{thin_points} function returns records based on coordinate thinning.
}
\details{
This function requires package spThin.
}
\examples{
thinned_data <- thin_points(data, accepted.name = "Galax urceolata")

}
