      SUBROUTINE OPTSUM(NSIG,SIGMA,IDIM,SIGSUM)
C
C CALCULATES INDIVIDUAL CHI SQUARES (BY FAMILY UNIT) FOR DETECTION OF
C OUTLIERS, USING THE FINAL RESULTS OF MAXIMUM LIKELIHOOD ESTIMATION.
C THE TWO SUBROUTINES ARE THE FOLLOWING:
C
C "OPTSUM" -- RETURNS THE SUM OVER ALL ELEMENTS OF SIGMA, WHICH IS
C             USED IN TURN BY "OPTOUT".  "OPTSUM" MUST BE CALLED EACH
C             TIME THE SIGMA MATRIX IS RECALCULATED FOR A NEW FAMILY
C             STRUCTURE.
C
C "OPTOUT" -- WRITES THE RESULTS TO UNIT "LFNOUT", ONE LINE PER FAMILY,
C             CONSISTING OF CHI SQUARE, DEGREES OF FREEDOM, AND LEVEL
C             EFFECT.  "OPTSUM" MUST BE CALLED AFTER THE QUADRATIC
C             FORM "DSD" IS CALCULATED FOR A GIVEN FAMILY.
C
C ARGUMENTS:
C   NSIG    -- ORDER OF CURRENT SIGMA MATRIX (FAMILY SIZE)
C   SIGMA   -- COVARIANCE MATRIX
C   IDIM    -- SIZE OF SIGMA AS DIMENSIONED
C   SIGSUM  -- SUM OF SIGMA(I,J) RETURNED BY "OPTSUM"
C   LFNOUT  -- LOGICAL UNIT FOR OUTPUT
C   IFAM    -- CURRENT FAMILY NUMBER
C   DSD     -- SCALER RESULT OF DVEC(TRANSPOSE) SIGMA DVEC
C   DVEC    -- DEVIATIONS (FROM GROUP MEANS) FOR EACH INDIVIDUAL
C
C LOGICAL VARIABLE "GOFOUT" SHOULD BE SET TO FLAG THE FINAL FUNCTION
C CALL.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION     SIGMA(IDIM,IDIM)
      LOGICAL       GOFOUT
C
      COMMON /GOF/  GOFOUT,LFNGOF
C
C GET DENOMINATOR TERM FOR LEVEL EFFECT:  SIGSUM=SUM OF ALL SIGMA(I,J)
C
      SIGSUM = 0.0
      IF (GOFOUT) THEN
         DO 120 I=1,NSIG
            DO 110 J=1,I
               SIGSUM = SIGSUM + 2.0 * SIGMA(J,I)
110         CONTINUE
            SIGSUM = SIGSUM + SIGMA(I,I)
120      CONTINUE
      END IF
      END
      SUBROUTINE OPTOUT(LFNOUT,IFAM,NSIG,DSD,DVEC,SIGSUM)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION     DVEC(*)
      LOGICAL       GOFOUT
C
      COMMON /GOF/  GOFOUT,LFNGOF
C
C GET NUMERATOR TERM FOR LEVEL EFFECT:  TOP=SUM OF ALL DVEC(I)
C
      IF (GOFOUT) THEN
         TOP = 0.0
         DO 210 I=1,NSIG
            TOP = TOP + DVEC(I)
210      CONTINUE
C
         IF (SIGSUM .EQ. 0.0) THEN
            call intpr('GOF: SIGMA TERM ZERO',-1,0,0)
            STOP
         END IF
         CHILEV = TOP**2 / SIGSUM
C
C       WRITE RESULTS
C
         IF (IFAM .EQ. 1) THEN
            CALL EJECT(LFNOUT)
            WRITE (LFNOUT,1100)
         END IF
         WRITE (LFNOUT,1110) IFAM, DSD, NSIG, CHILEV
C
      END IF
C
 1100 FORMAT (' GOODNESS OF FIT CHI SQUARES',
     +      //' ',10X,'UNIT #', 10X,'OVERALL (DF)', 10X,'LEVEL (DF=1)')
 1110 FORMAT (' ',10X,  I6,     10X,F7.2,' (',I2,')',  10X,F7.2)
C
      END
