      INTEGER FUNCTION IXNO(STRING,ICOL,ISTAT)
C
C CONVERTS A CHARACTER-STRING INTEGER TO NUMERIC FORM.
C (THE STRING IS TERMINATED BY ANY NON-NUMERIC CHARACTER)
C
C INPUT ARGUMENTS:
C     STRING -- INPUT STRING
C     ICOL   -- COLUMN IN 'STRING' TO BEGIN PROCESSING
C
C OUTPUT ARGUMENTS:
C     ICOL   -- PUSHED TO NEXT COLUMN FOLLOWING NUMBER
C     ISTAT  -- 0=OK ; -1=ERROR ; -2=BLANK
C
C FUNCTION VALUE -- INTEGER FORM OF INPUT STRING
C
      CHARACTER   STRING*(*)
      LOGICAL     MINUS
C
C    CHECK ICOL:
      NCHARS = LEN(STRING)
      IF (ICOL.LE.0 .OR. ICOL.GT.NCHARS) GO TO 810
C
C    INITIALIZE COLUMN POINTERS, AND CHECK FOR BLANK STRING:
      IFIRST = NSPACE(STRING,ICOL,ISTAT)
      IF (ISTAT .NE. 0) GO TO 820
C
      ILAST  = 0
      I = IFIRST
C
C    HANDLE MINUS SIGN:
      IF (STRING(I:I) .EQ. '-') THEN
         MINUS = .TRUE.
         I = I + 1
      ELSE
         MINUS = .FALSE.
      END IF
C
C    FIND FIRST NON-DIGIT:
      IXNO = 0
100   IF (I .GT. NCHARS) GO TO 199
         IDIGIT = ICHAR( STRING(I:I) ) - ICHAR('0')
         IF ( IDIGIT .LT. 0 .OR. IDIGIT .GT. 9) GO TO 199
         IXNO = IXNO*10 + IDIGIT
         ILAST = I
         I = I + 1
      GO TO 100
C
199   CONTINUE
C
C    CHECK FOR ZERO LENGTH STRING:
      N = ILAST - IFIRST + 1
      IF (N .LE. 0) GO TO 810
C
C    CHANGE SIGN
      IF (MINUS) IXNO = -IXNO
C
C    FINALLY, PUSH ICOL PAST THE NUMBER:
      ICOL = ILAST + 1
      GO TO 900
C
C INVALID NUMBER
C
810   ISTAT = -1
      IXNO = 0
      GO TO 999
C
C BLANK STRING
C
820   ISTAT = -2
      IXNO = 0
      GO TO 999
C
C SUCCESSFUL RETURN
C
900   ISTAT = 0
999   RETURN
      END
