% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/signal_split.R
\docType{methods}
\name{signal_split}
\alias{signal_split}
\alias{signal_split-method}
\alias{signal_split,GammaSpectrum-method}
\title{Split}
\usage{
signal_split(object, ...)

\S4method{signal_split}{GammaSpectrum}(object, groups)
}
\arguments{
\item{object}{A \linkS4class{GammaSpectrum} object.}

\item{...}{Currently not used.}

\item{groups}{A a \code{\link{factor}} in the sense that \code{as.factor(groups)} defines
the grouping (see \code{\link{split}}).}
}
\value{
A \linkS4class{GammaSpectra} object.
}
\description{
Split
}
\examples{
## Import CNF files
spc_file <- system.file("extdata/LaBr.CNF", package = "gamma")
spc <- read(spc_file)

## Plot spectrum
plot(spc)

## Slice
sliced <- signal_slice(spc)
plot(sliced)

sliced <- signal_slice(spc, -c(1:35))
plot(sliced)

sliced <- signal_slice(sliced, 450:550)
plot(sliced)

## Split
g <- rep(c("A", "B", "C"), c(250, 500, 274))
splited <- signal_split(spc, g)
plot(splited, facet = TRUE)
}
\seealso{
Other signal processing: 
\code{\link{baseline}},
\code{\link{peaks_find}()},
\code{\link{peaks_search}()},
\code{\link{signal_integrate}()},
\code{\link{signal_slice}()},
\code{\link{signal_stabilize}()},
\code{\link{smooth}()}
}
\author{
N. Frerebeau
}
\concept{signal processing}
