%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  
% 
% on Wed Feb 08 14:37:37 2006.
% 
% Generator was the Rdoc class, which is part of the R.oo package written
% by Henrik Bengtsson, 2001-2004.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 \name{newRandomCollection.Chromosome}
\alias{newRandomCollection.Chromosome}
\alias{Chromosome.newRandomCollection}
\alias{newRandomCollection.Chromosome}
\alias{newRandomCollection,Chromosome-method}
\keyword{methods}
\keyword{internal}


 \title{Creates a list of cloned chromosomes object with its internal values generated by random}

 \description{
  Creates a list of cloned chromosomes object with its internal values generated by random.
 }

 \usage{\method{newRandomCollection}{Chromosome}(.O, ...)}

 \arguments{
   \item{n}{Number of object clones.}
 }

 \value{
  Returns a list with cloned objects and random generated values.
 }

 \details{
  For all cloned objects, \code{generateRandom} method is called to replace internal values.
 }

 \examples{
   cr <- Chromosome(genes=newCollection(Gene(shape1=1, shape2=100),5))
   cr
 
   # creation and random generation at the same time
   ni <- Niche(chromosomes = newRandomCollection(cr, 2))
   ni
 }

 \references{Goldberg, David E. 1989 \emph{Genetic Algorithms in Search, Optimization and Machine Learning}. Addison-Wesley Pub. Co. ISBN: 0201157675}

 \author{Victor Trevino. Francesco Falciani Group. University of Birmingham, U.K. http://www.bip.bham.ac.uk/bioinf}

 \seealso{
   For more information see \code{\link{Chromosome}}.
   \code{\link{unObject}},
   \code{\link{as.list.Object}},
   \code{\link{newCollection.Chromosome}},
   \code{\link{Chromosome}}.
 }

 \keyword{methods}
