%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  
% 
% on Wed Feb 08 14:37:47 2006.
% 
% Generator was the Rdoc class, which is part of the R.oo package written
% by Henrik Bengtsson, 2001-2004.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 \name{World}
\docType{class}
\alias{World}
\keyword{classes}


 \title{The representation of a set of niches with migration for genetic algorithms}

  \section{Class}{Package:  galgo \cr
\bold{Class World}\cr

\code{\link[R.oo]{Object}}\cr
\code{~~|}\cr
\code{~~+--}\code{World}\cr

\bold{Directly known subclasses:}\cr
\cr

public static class \bold{World}\cr
extends \link[R.oo]{Object}\cr

}

 \description{
  Represents a set of nices for the genetic algorithm. Because the niches
  are ``closed populations'', it is sometimes needed exchange information
  bewteen niches (or ``islands''). The \code{World} object implements the exchange
  of chromosomes between niches, and to be compatible, it also implements the needed
  methods than an usual niche but considering the immigration property.
  Thus, the \code{Galgo} object can receive a list of Niches, a list of
  Worlds, or a list of any mixture of them.

 }

 \usage{World(id=0,
	niches=list(),
	immigration=0,
	maxFitness=0,
	bestFitness=0,
	maxChromosome=NULL,
	bestChromosome=NULL,
	generation=0,
	...)}

 \arguments{
   \item{id}{A way to identify the object.}
   \item{niches}{A list of defined niches composing the world. However, it can be a list containing even \code{World} objects.}
   \item{immigration}{It can be \code{NULL}, a \code{function}, or a \code{vector}. When it is \code{NULL} immigration is disabled. When it is a \code{function} it is evaluated using the same \code{World} object as parameter, the result should be a numeric value. When the length of \code{immigration} is greather than 1 a cycled version is used depending on the \code{generation}. If the resulted or selected numeric value is greather than 1 it is interpreted as the number of chromosomes to migrate, otherwise it is assumed to be a probability to migrate one chromosome. The final \code{I} best chromosomes to migrate apply to all niches.}
   \item{bestFitness}{The best fitness ever visited.}
   \item{maxFitness}{The maximum fitness from the current chromosomes. It should be 0 initially, but it is included for generalization.}
   \item{maxChromosome}{The chromosome whose fitness is maximum from the current chromosomes. It should be NULL initially, but it is included for generalization.}
   \item{bestChromosome}{The chromosome whose fitness is maximum visited ever. It should be NULL initially, but it is included for generalization.}
   \item{generation}{For internal use only.}
   \item{...}{Other user named values to include in the object (like pMutation, pCrossover or any other).}
 }

 \section{Fields and Methods}{
  \bold{Methods:}\cr
\tabular{rll}{
 \tab \code{\link[galgo:best.World]{best}} \tab Returns the best chromosome.\cr
 \tab \code{\link[galgo:bestFitness.World]{bestFitness}} \tab Returns the fitness of the best chromosome.\cr
 \tab \code{\link[galgo:clone.World]{clone}} \tab Clones itself and its niches.\cr
 \tab \code{\link[galgo:evaluate.World]{evaluate}} \tab Evaluate all niches with a fitness function.\cr
 \tab \code{\link[galgo:generateRandom.World]{generateRandom}} \tab Generates random values for all niches in the world.\cr
 \tab \code{\link[galgo:length.World]{length}} \tab Gets the number of niches defined in the world.\cr
 \tab \code{\link[galgo:max.World]{max}} \tab Returns the chromosome whose current fitness is maximum.\cr
 \tab \code{\link[galgo:maxFitness.World]{maxFitness}} \tab Returns the fitness of the maximum chromosome.\cr
 \tab \code{\link[galgo:newCollection.World]{newCollection}} \tab Generates a list cloning an object.\cr
 \tab \code{\link[galgo:newRandomCollection.World]{newRandomCollection}} \tab Creates a list of cloned object with its internal values generated by random.\cr
 \tab \code{\link[galgo:plot.World]{plot}} \tab Plots information about world object.\cr
 \tab \code{\link[galgo:print.World]{print}} \tab Prints the representation of a world object.\cr
 \tab \code{\link[galgo:progeny.World]{progeny}} \tab Calls progeny method to all niches in the world object.\cr
 \tab \code{\link[galgo:refreshStats.World]{refreshStats}} \tab Updates the internal statistics from the current population.\cr
 \tab \code{\link[galgo:reInit.World]{reInit}} \tab Erases all internal values in order to re-use the world object.\cr
 \tab \code{\link[galgo:summary.World]{summary}} \tab Prints the representation and statistics of the world object.\cr
}


\bold{Methods inherited from Object}:\cr
as.list, unObject, $, $<-, [[, [[<-, as.character, attach, clone, detach, equals, extend, finalize, getFields, getInstanciationTime, getStaticInstance, hasField, hashCode, ll, load, objectSize, print, save


 }

 \examples{
   cr <- Chromosome(genes=newCollection(Gene(shape1=1, shape2=100),5))
   ni <- Niche(chromosomes=newRandomCollection(cr, 10))
   wo <- World(niches=newRandomCollection(ni,2))
   wo

   progeny(wo) # returns the chromosomes indexes that were mutated
 }

 \references{Goldberg, David E. 1989 \emph{Genetic Algorithms in Search, Optimization and Machine Learning}. Addison-Wesley Pub. Co. ISBN: 0201157675}

 \author{Victor Trevino. Francesco Falciani Group. University of Birmingham, U.K. http://www.bip.bham.ac.uk/bioinf}

 \seealso{
   \code{\link{Gene}},
   \code{\link{Chromosome}},
   \code{\link{Niche}},
   \code{\link{Galgo}},
   \code{\link{BigBang}}.
 }

 \keyword{programming}
 \keyword{methods}
