%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  
% 
% on Wed Feb 08 14:37:32 2006.
% 
% Generator was the Rdoc class, which is part of the R.oo package written
% by Henrik Bengtsson, 2001-2004.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{Chromosome}
\docType{class}
\alias{Chromosome}
\keyword{classes}


\title{The representation of a set of genes for genetic algorithms}

 \section{Class}{Package:  galgo \cr
\bold{Class Chromosome}\cr

\code{\link[R.oo]{Object}}\cr
\code{~~|}\cr
\code{~~+--}\code{Chromosome}\cr

\bold{Directly known subclasses:}\cr
\cr

public static class \bold{Chromosome}\cr
extends \link[R.oo]{Object}\cr

}

\description{
 Represents a set of genes for the genetic algorithm. The chromosome contains
 all current values of each gene and will be evaluated using
 a ``fitness'' function similar to those defined by Goldberg. The fitness function
 normally depends on the \code{Galgo} object.

 See references for Genetic Algorithms.
}

\usage{Chromosome(id=0,
	genes=list(),
	getValues=function(x, ...) unlist(lapply(x, ...)),
	decode=function(x) genes(x),
	values=list(),
	...)}

\arguments{
  \item{id}{A way to identify the object.}
  \item{genes}{A list of defined Gene objects composing the chromosome.}
  \item{getValues}{A function to be evaluated for every gene to obtain a value. In general, the result could be any object in a list. In particular, the default is a vector of current gene values.}
  \item{decode}{A function that converts the chromosome representation in real values. It is used mainly for output purposes and for frequency counting. It has no effect for variable selection in microarray data since the default \code{decode} is directly the gene value.}
  \item{values}{The specific initial values. If \code{value} is not specified, \code{getValues} function is ran to obtain initial values.}
  \item{...}{Other user named values to include in the object.}
}

\section{Fields and Methods}{
 \bold{Methods:}\cr
\tabular{rll}{
 \tab \code{\link[galgo:as.double.Chromosome]{as.double}} \tab Converts the chromosome values (genes) to its numerical representation.\cr
 \tab \code{\link[galgo:clone.Chromosome]{clone}} \tab Clones itself and its genes.\cr
 \tab \code{\link[galgo:decode.Chromosome]{decode}} \tab Converts the gene values to user-readable values.\cr
 \tab \code{\link[galgo:generateRandom.Chromosome]{generateRandom}} \tab Generates random values for all genes in the chromosome.\cr
 \tab \code{\link[galgo:genes.Chromosome]{genes}} \tab Converts the genes values to a numeric vector.\cr
 \tab \code{\link[galgo:length.Chromosome]{length}} \tab Gets the number of genes defined in the chromosome.\cr
 \tab \code{\link[galgo:mutate.Chromosome]{mutate}} \tab Mutates a chromosome in specific positions.\cr
 \tab \code{\link[galgo:newCollection.Chromosome]{newCollection}} \tab Generates a list of chromosomes cloning the original chromosome object.\cr
 \tab \code{\link[galgo:newRandomCollection.Chromosome]{newRandomCollection}} \tab Creates a list of cloned chromosomes object with its internal values generated by random.\cr
 \tab \code{\link[galgo:print.Chromosome]{print}} \tab Prints the representation of the chromosome object.\cr
 \tab \code{\link[galgo:reInit.Chromosome]{reInit}} \tab Erases all internal values in order to re-use the object.\cr
 \tab \code{\link[galgo:summary.Chromosome]{summary}} \tab Prints the representation of the chromosome object and all its genes.\cr
}


\bold{Methods inherited from Object}:\cr
as.list, unObject, $, $<-, [[, [[<-, as.character, attach, clone, detach, equals, extend, finalize, getFields, getInstanciationTime, getStaticInstance, hasField, hashCode, ll, load, objectSize, print, save


}

\examples{
  cr <- Chromosome(genes=newCollection(Gene(shape1=1, shape2=100),5))
  cr
}

\references{Goldberg, David E. 1989 \emph{Genetic Algorithms in Search, Optimization and Machine Learning}. Addison-Wesley Pub. Co. ISBN: 0201157675}

\author{Victor Trevino. Francesco Falciani Group. University of Birmingham, U.K. http://www.bip.bham.ac.uk/bioinf}

\seealso{
  \code{\link{Gene}}.
  \code{\link{Niche}}.
  \code{\link{World}}.
  \code{\link{Galgo}}.
  \code{\link{BigBang}}.
}

\keyword{programming}
\keyword{methods}
