% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mresp_hsced}
\alias{mresp_hsced}
\title{Simulated Mixed Response Data with Heteroscedastic Residuals}
\format{
\subsection{\code{mresp_hsced} A data frame with 4000 rows and 5 columns:}{

\describe{
\item{id}{Subject ID.}
\item{x}{Predictor variable.}
\item{y}{Matrix whose first column is the response and whose second
column equals 1 if the observation is conditionally normally distributed
and 2 if the observation is conditionally binomially distributed.}
\item{itemgroup}{Factor variable which equals "a" for the normally
distributed responses and "b" for the binomially distributed response
(with 1 trial).}
\item{grp}{Grouping variable denoting which of the two residual standard
deviations apply. Only relevant for the normally distributed responses.}
\item{isgauss}{Dummy variable indicating whether the observation on the
given line is normally (Gaussian) distributed or not.}
}
}
}
\usage{
mresp_hsced
}
\description{
Mixed response dataset with one set of normally distributed
responses and one set of binomially distributed responses. The normally
distributed response follow two different residual standard deviations.
}
\seealso{
Other datasets: 
\code{\link{cognition}},
\code{\link{diet}},
\code{\link{epilep}},
\code{\link{hsced}},
\code{\link{latent_covariates}},
\code{\link{latent_covariates_long}},
\code{\link{lifespan}},
\code{\link{mresp}}
}
\concept{datasets}
\keyword{datasets}
