% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{mboottest}
\alias{mboottest}
\title{Arbitrary Linear Hypothesis Testing for Regression Models via Wald-Tests}
\usage{
mboottest(object, ...)
}
\arguments{
\item{object}{An object of type lm, fixest or felm}

\item{...}{other arguments}
}
\value{
An object of class \code{mboottest}.
}
\description{
\code{mboottest} is a S3 method that allows for arbitrary linear hypothesis testing
for objects of class lm, fixest, felm
}
\section{Setting Seeds}{

To guarantee reproducibility, you can either use \verb{boottest()'s} \code{seed} function argument, or
set a global random seed via
\itemize{
\item \code{set.seed()} when using
\enumerate{
\item the lean algorithm (via \code{boot_algo = "R-lean"}), 2) the heteroskedastic wild bootstrap
\item the wild cluster bootstrap via \code{boot_algo = "R"} with Mammen weights or 4) \code{boot_algo = "WildBootTests.jl"}
}
\item \code{dqrng::dqset.seed()} when using \code{boot_algo = "R"} for Rademacher, Webb or Normal weights
}
}

\references{
Roodman et al., 2019, "Fast and wild: Bootstrap inference in
STATA using boottest", The STATA Journal.
(\url{https://journals.sagepub.com/doi/full/10.1177/1536867X19830877})

Cameron, A. Colin, Jonah B. Gelbach, and Douglas L. Miller. "Bootstrap-based improvements for inference with clustered errors." The Review of Economics and Statistics 90.3 (2008): 414-427.

MacKinnon, James G., and Matthew D. Webb. "The wild bootstrap for few (treated) clusters." The Econometrics Journal 21.2 (2018): 114-135.

MacKinnon, James. "Wild cluster bootstrap confidence intervals." L'Actualite economique 91.1-2 (2015): 11-33.

Webb, Matthew D. Reworking wild bootstrap based inference for clustered errors. No. 1315. Queen's Economics Department Working Paper, 2013.
}
\seealso{
\link[fwildclusterboot]{mboottest.lm} \link[fwildclusterboot]{mboottest.felm} \link[fwildclusterboot]{mboottest.fixest}
}
