## Prediction of minimum temperature for frost forecasting in agriculture

[![Build Status](https://travis-ci.org/anadiedrichs/frost.svg?branch=master)](https://travis-ci.org/anadiedrichs/frost) [![DOI](https://zenodo.org/badge/128426264.svg)](https://zenodo.org/badge/latestdoi/128426264)

### Description

This package contains a compilation of empirical methods used by farmers and agronomic engineers to predict the minimum temperature to detect a frost event. 

These functions use variables such as environmental temperature, relative humidity, and dew point.

### Installation

If you don't have package **devtools** installed, run the following commands.

`` install.packages("devtools") ``

`` library(devtools) ``

To install the package from the GitHub repo, run

`` install_github("anadiedrichs/frost")``

<img src="./vignettes/logo-frost.png" width="250">

### More info

You can have more information about how to use this package in the [Introduction vignette](vignettes/Introduction.Rmd)

### How to cite this package

`> citation("frost")`

To cite package ‘frost’ in publications use:

Ana Laura Diedrichs (2018). frost: Prediction of minimum temperature for frost forecasting in agriculture. R package version 0.0.2. https://github.com/anadiedrichs/frost

A BibTeX entry for LaTeX users is

@Manual{,

title = {frost: Prediction of minimum temperature for frost forecasting in agriculture},

author = {Ana Laura Diedrichs},

year = {2018},

note = {R package version 0.0.2},

url = {https://github.com/anadiedrichs/frost},

}

