% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{view_db}
\alias{view_db}
\title{View a Regional FQA Database}
\source{
See \code{db_names} function for citations
}
\usage{
view_db(db)
}
\arguments{
\item{db}{A character string representing the regional FQA database to use. See
\code{db_names} for a list of potential values and the \code{fqadata} R package
where the databases are hosted.}
}
\value{
A data frame with 12 variables:
\describe{
\item{name}{Latin name for species, either accepted name or synonym}
\item{name_origin}{Indicates if the name is the accepted scientific name or a synonym}
\item{acronym}{A unique acronym for each species. Not always consistent between FQA databases}
\item{accepted_scientific_name}{The accepted botanical nomenclature}
\item{family}{Taxonomic family of species}
\item{nativity}{Nativity status. Native, introduced, and undetermined are possible values}
\item{c}{Coefficient of Conservatism (C Value)}
\item{w}{Wetness Coefficient}
\item{wetland_indicator}{Wetland indicator status}
\item{physiognomy}{Structure or physical appearance of species}
\item{duration}{Lifespan of species}
\item{common_name}{Common name(s) for species}
\item{fqa_db}{Regional FQA database}
}
}
\description{
Create a data frame containing an entire regional FQA database.
}
\examples{
view_db("michigan_2014")
}
