% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictTrgs.R
\name{predictTrgs}
\alias{predictTrgs}
\title{Impute response variables across the landscape}
\usage{
predictTrgs(
  model = NULL,
  x = NULL,
  nrows = 200,
  nnID = TRUE,
  nnDist = TRUE,
  filename = "",
  par = FALSE,
  threads = 2,
  progress = TRUE,
  ...
)
}
\arguments{
\item{model}{A trained kNN model obtained from \code{\link[foster]{trainNN}}}

\item{x}{Raster object where each layer corresponds to a predictor variable calculated at targets}

\item{nrows}{number of rows processed at a time. Default is 200 .}

\item{nnID}{Logical. Should the ID of each target's nearest neighbor used for imputation be returned?}

\item{nnDist}{Logical. Should the distance to each target's nearest neighbor used for imputation be returned?}

\item{filename}{Character. Output file name including path to directory and
eventually extension.Default is \code{""} (output not written to disk).}

\item{par}{Logical. Should imputation be performed on parallel threads?}

\item{threads}{Integer. Number of parallel threads (relevant only if par=TRUE)}

\item{progress}{Logical. If TRUE (default) a progress bar is displayed.}

\item{...}{Other arguments passed to \code{\link[raster]{writeRaster}}}
}
\value{
A RasterStack object where the first layers correspond to the imputed response variables and the remaining layers to the nearest neighbor(s) ID (if \code{nnID = TRUE}) and nearest neighbor(s) distance (if \code{nnDist = TRUE})
}
\description{
This function finds the k-NN of target observations and imputes response variables. \code{X} is a raster object where each layer correspond to one of the predictor variable used to train the k-NN model \code{model} obtained from \code{\link[foster]{trainNN}}.
}
\details{
The method used to impute the NN is set from the kNN model trained by \code{\link[foster]{trainNN}}. If \code{k=1} the value of the single closest NN is imputed. If \code{k>1}, the closest, mean, median or weighted distance mean (default) of all k NN values is imputed. This is set using the \code{impute.cont} and \code{impute.fac} arguments of \code{\link[foster]{trainNN}}.

The raster \code{x} is processed as blocks of \code{nrows} to avoid creating very large objects (several Gb) that couldn't be stored in memory. However, low values of \code{nrows} slow down processing. Depending on the amount of RAM available on your computer and on the size of the area where k-NN need to be calculated, it is possible to process more rows at the same time and considerably reduce processing time.
}
\examples{
# Load data
# kNN_model: trained kNN model (from trainNN)
# X_vars: RasterStack of predictor variables
load(system.file("extdata/examples/example_predictTrgs.RData", package =
"foster"))

Y_imputed <- predictTrgs(model=kNN_model, x = X_vars, nnID = TRUE,
nnDist = TRUE)
}
\seealso{
\code{\link[yaImpute]{newtargets}}, \code{\link[yaImpute]{impute.yai}}
}
