% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_units.R
\name{format_units}
\alias{format_units}
\title{Format values with measurement units}
\usage{
format_units(
  x,
  digits = 1,
  ...,
  unit = NULL,
  unit_form = NULL,
  big_mark = NULL
)
}
\arguments{
\item{x}{Vector of class numeric or class units.}

\item{digits}{Numeric scalar, a positive integer. Applied as the \code{digits}
argument of \code{base::format()}. Enough decimal places are included such that
the smallest magnitude value has this many significant digits.}

\item{...}{Not used, force later arguments to be used by name.}

\item{unit}{Character scalar, units label compatible with 'units' package.
For \code{x} class numeric, transform to class units in \code{unit} measurement
units. For \code{x} class units, convert to \code{unit} measurement units. If empty,
existing class units retained.}

\item{unit_form}{Character scalar. Possible values are "standard" (default)
and "implicit" (implicit exponent form). In standard form, units are
related with arithmetic symbols for multiplication, division, and powers,
e.g., \code{"kg/m^3"} or \code{"W/(m*K)"}. In implicit exponent form, symbols are
separated by spaces and numbers represent exponents, e.g., \code{"kg m-3"} or
\code{"W m-1 K-1"}.}

\item{big_mark}{Character. Applied as the \code{big.mark} argument of
\code{base::format()}. Default is \code{""}. If a period is selected for \code{big_mark},
the decimal mark is changed to a comma.}
}
\value{
A character vector of numbers with appended measurement units.
}
\description{
Format a vector of numbers as character strings with measurement units
appended via the 'units' package.
}
\details{
This function is a wrapper for \code{\link[units:units]{units::as_units()}} and \code{\link[base:format]{base::format()}}.
Numeric class input is converted to units class. Units class input, if
convertible, is converted to the specified measurement units; if none are
specified, the existing measurement units are retained. The result in all
cases is converted to class character using \code{base::format()} with preset
arguments: \code{trim = TRUE} and \code{scientific = FALSE}. The output has the form
\code{"a [u]"}, where \code{a} is the number in decimal notation and \code{u} is a
measurement units label.
}
\examples{
# Scalar value, class numeric
x <- 101300
format_units(x, unit = "Pa")

# Scalar value, class units
x <- 101300
units(x) <- "Pa"
format_units(x, unit = "hPa")
format_units(x, digits = 3, unit = "psi")

# Vectors (atmos and metals data included in formatdown)
x <- atmos$dens
units(x) <- "kg/m^3"
format_units(x, unit = "g/m^3")
format_units(x, unit = "g/m^3", unit_form = "implicit")

x <- atmos$pres
units(x) <- "Pa"
format_units(x, big_mark = ",")
format_units(x, unit = "hPa")

x <- metals$thrm_cond
units(x) <- "W m-1 K-1"
format_units(x, digits = 2)
format_units(x, digits = 2, unit_form = "implicit")

}
\seealso{
Other format_*: 
\code{\link{format_decimal}()},
\code{\link{format_power}()},
\code{\link{format_text}()}
}
\concept{format_*}
