% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/private.R
\name{prFpGetGraphTicksAndClips}
\alias{prFpGetGraphTicksAndClips}
\title{A helper function to forestplot}
\usage{
prFpGetGraphTicksAndClips(xticks, xticks.digits, grid, xlog, xlab,
  lwd.xaxis, col, txt_gp, clip, zero, x_range, mean, graph.pos)
}
\arguments{
\item{xticks}{Optional user-specified x-axis tick marks. Specify NULL to use
the defaults, numeric(0) to omit the x-axis. By adding a labels-attribute,
\code{attr(my_ticks, "labels") <- ...} you can dictate the outputted text
at each tick. If you specify a boolean vector then ticks indicated with
FALSE wont be printed. Note that the labels have to be the same length
as the main variable.}

\item{xticks.digits}{The number of digits to allow in the x-axis if this
is created by default}

\item{grid}{If you want a discrete gray dashed grid at the level of the
ticks you can set this parameter to \code{TRUE}. If you set the parameter
to a vector of values lines will be drawn at the corresponding positions.
If you want to specify the \code{\link[grid]{gpar}} of the lines then either
directly pass a \code{\link[grid]{gpar}} object or set the gp attribute e.g.
\code{attr(line_vector, "gp") <- \link[grid]{gpar}(lty=2, col = "red")}}

\item{xlog}{If TRUE, x-axis tick marks are to follow a logarithmic scale, e.g. for
logistic regressoin (OR), survival estimates (HR), poisson regression etc.
\emph{Note:} This is an intentional break with the original \code{\link[rmeta]{forestplot}}
function as I've found that exponentiated ticks/clips/zero effect are more
difficult to for non-statisticians and there are sometimes issues with rounding
the tick marks properly.}

\item{xlab}{x-axis label}

\item{lwd.xaxis}{lwd for the xaxis, see \code{\link[grid]{gpar}}}

\item{col}{Set the colors for all the elements. See \code{\link{fpColors}} for
details}

\item{txt_gp}{Set the fonts etc for all text elements. See \code{\link{fpTxtGp}}
for details}

\item{clip}{Lower and upper limits for clipping confidence intervals to arrows}

\item{zero}{x-axis coordinate for zero line. If you provide a vector of length 2 it
will print a rectangle instead of just a line. If you provide NA the line is supressed.}

\item{x_range}{The range that the values from the different confidence
interval span}

\item{mean}{The original means, either matrix or vector}

\item{graph.pos}{The position of the graph element within the table of text. The
position can be \code{1-(ncol(labeltext) + 1)}. You can also choose set the positin
to \code{"left"} or \code{"right"}.}
}
\value{
\code{list} Returns a list with axis_vp, axisGrob, labGrob, zero and clip
}
\description{
Gets the x-label and zero-bar details
}
\keyword{internal}
