% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot_helpers.R
\name{prFpDrawLine}
\alias{prFpDrawLine}
\title{Draws a straight line}
\usage{
prFpDrawLine(lower_limit, upper_limit, clr.line, lwd, lty, y.offset,
  vertices, vertices.height = 0.1)
}
\arguments{
\item{lower_limit}{The lower limit of the confidence line.
A native numeric variable that can actually be
outside the boundaries. If you want to see if it
is outside then convert it to 'npc' and see if the
value ends up more than 1 or less than 0. Here's how
you do the conversion:
\code{convertX(unit(upper_limit, "native"), "npc", valueOnly = TRUE)}
and the \code{\link[grid]{convertX}} together with \code{\link[grid]{unit}}
is needed to get the right values while you need to provide the valueOnly
as you cannot compare a unit object.}

\item{upper_limit}{The upper limit of the confidence line. See
lower_limit for details.}

\item{clr.line}{The color of the line.}

\item{lwd}{Line width, see \code{\link[grid]{gpar}}}

\item{lty}{Line type, see \code{\link[grid]{gpar}}}

\item{y.offset}{If you have multiple lines they need an offset in
the y-direction.}

\item{vertices}{Set this to TRUE if you want the ends of the confidence
intervals to be shaped as a T. This is set default to TRUE if you have
any other line type than 1 since there is a risk of a dash occurring
at the very end, i.e. showing incorrectly narrow confidence interval.}

\item{vertices.height}{The height hoft the vertices. Defaults to npc units
corresponding to 10\% of the row height.}
}
\value{
\code{void}
}
\description{
If the line is outside the boundaries the line
is clipped with an arrow at the limit indicating
that it continues. If the lower limit is not below
the upper limit the line is not drawn.
}
\keyword{internal}
