% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot_helpers.R
\name{fpLegend}
\alias{fpLegend}
\title{A function for the legend used in forestplot()}
\usage{
fpLegend(pos = "top", gp = NULL, r = unit(0, "snpc"),
  padding = unit(ifelse(!is.null(gp), 3, 0), "mm"), title = NULL)
}
\arguments{
\item{pos}{The position of the legend, either at the "top" or the "right" unlesss
positioned inside the plot. If you want the legend to be positioned inside the plot
then you have to provide a list with the same x & y qualities as \code{\link[graphics]{legend}}.
For instance if you want the legend to be positioned at the top right corner then
use \code{pos = list("topright")} - this is equivalent to \code{pos = list(x=1, y=1)}.
If you want to have a distance from the edge of the graph then add a inset to the list,
e.g. \code{pos = list("topright", "inset"=.1)} - the inset should be either a \code{\link[grid]{unit}}
element or a value between 0 and 1. The default is to have the boxes aligned vertical, if
you want them to be in a line then you can specify the "align" option, e.g.
\code{pos = list("topright", "inset"=.1, "align"="horizontal")}}

\item{gp}{The \code{\link[grid]{gpar}} options for the legend. If you want
the background color to be light grey then use \code{gp = gpar(fill = "lightgrey")}.
If you want a border then set the col argument: \code{gp = gpar(fill = "lightgrey", col="black")}.
You can also use the lwd and lty argument as usual, \code{gp = gpar(lwd=2, lty=1)}, will result
in a black border box of line type 1 and line width 2.}

\item{r}{The box can have rounded edges, check out \code{\link[grid]{grid.roundrect}}. The
r option should be a \code{\link[grid]{unit}} object. This is by default \code{unit(0, "snpc")}
but you can choose any value that you want. The \code{"snpc"} unit is the preferred option.}

\item{padding}{The padding for the legend box, only used if box is drawn. This is
the distance from the border to the text/boxes of the legend.}

\item{title}{The title of the legend if any}
}
\value{
\code{list} Returns a list with all the elements
}
\description{
This function encapsulates all the legend options that are used in the
\code{\link{forestplot}} function. This is in order to limit the crowding
among the arguments for the \code{\link{forestplot}} call.
}
\seealso{
Other forestplot functions: \code{\link{forestplot}},
  \code{\link{fpColors}}, \code{\link{fpDrawNormalCI}}
}
