% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsffq_simple_functions.R
\name{nutrients}
\alias{nutrients}
\title{Nutrients}
\usage{
nutrients(row)
}
\arguments{
\item{row}{/contains two components. f1:f85 1-9, representing different
frequency factor responses from the hsffq. These will be stored in columns
2-86 in the row you plug in A value representing participant's age. This
will be stored in column 1 of the input row}
}
\value{
the row or dataframe returned will have 11 entries, representing
  total daily amounts of 7 micronutrients, 3 macronutrients, and calories for
  each participant. These columns will be labeled
}
\description{
The Nutrients function takes the age of a participant and their responses on
the hsffq to generate an estimate of the participant's total daily
micronutrients, macronutrients, and calories consumed for each food
}
\examples{
random_integers <- sample(1:8, 85, replace=TRUE)
vec <- c(6.2, random_integers)
nutrients(vec)

rquestionnaire <- function(n, n_food_questions = 85) {
  mat <- matrix(
    sample(1:9, n_food_questions*n, replace = TRUE),
    nrow = n, ncol = n_food_questions
  )
  df <- data.frame( age = round(runif(n, 2, 11), digits = 1) )
  cbind(df, as.data.frame(mat))
}
df <- rquestionnaire(5)

df_results <- data.frame()
for (i in 1:nrow(df)) {
result <- nutrients(df[i,])
df_results <- rbind(df_results, result)
}


}
