% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_simulated_cat_bin.R
\name{boot_simulated_cat_bin}
\alias{boot_simulated_cat_bin}
\title{Confidence-interval bootstraps on simulated independent variables}
\usage{
boot_simulated_cat_bin(type = c("cat", "bin", "bincat"),
  method = c("mic", "mi"), simu = 10, boots = 5000, size = 500,
  percentile = 0.99)
}
\arguments{
\item{type}{: the type of the simulated variables: \code{cat} is for
2 ordinal variables, \code{bin} is for 2 binary variables, \code{bincat}
is for 1 binary and 1 ordinal variable.}

\item{method}{: the method used to calculate the association : mutual
information (\code{mi}), or the maximal information coefficient (\code{mic}).}

\item{simu}{: the number of simulated pairs of variables. For each pair,
the confidence-interval bootstrap is calculated from the bootstrap distribution
of the MI/MIC of between the two pairs. At the end of the program, the mean of
the chosen percentile is given. Default is 10.}

\item{boots}{: the number of bootstraps per simulation. Default is 5000.}

\item{size}{: the size of the sample. Default is 500.}

\item{percentile}{: the percentile kept. Default is 0.99 (the 99th percentile).}
}
\value{
The mean of the percentile values.
}
\description{
Create a defined number of simulated independent random variables of
a given \code{size} according to \code{type} : 2 ordinal variables,
2 binary variables, 1 binary and 1 ordinal variable.
A number of bootstraps are then performed on the sample to calculate
a confidence interval of the bootstrap distribution of the chosen method:
mutual information or the maximal information coefficient.
The percentile method is used to calculate this interval.
}
\examples{

boot_simulated_cat_bin("cat", "mic", 2, 500)
}
\references{
Reshef et al. (2011) <doi:10.1126/science.1205438>

Meyer et al. (2008) <doi:10.1186/1471-2105-9-461>
}
