% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkPriorAndMisClassCost}
\alias{checkPriorAndMisClassCost}
\title{Check and Normalize Prior Probabilities and Misclassification Costs}
\usage{
checkPriorAndMisClassCost(prior, misClassCost, response)
}
\arguments{
\item{prior}{A numeric vector representing the prior probabilities for each
class in the response variable. If \code{NULL}, the observed frequencies of the
response are used as the default prior.}

\item{misClassCost}{A square matrix representing the misclassification costs
for each pair of classes in the response variable. If \code{NULL}, a default
misclassification matrix is created where all misclassifications have a
cost of 1 and correct classifications have a cost of 0.}

\item{response}{A factor representing the response variable with multiple
classes.}
}
\value{
A list containing: \item{prior}{A normalized vector of prior
probabilities for each class.} \item{misClassCost}{A square matrix
representing the misclassification costs, with rows and columns labeled by
the levels of the response variable.}
}
\description{
This function verifies and normalizes the provided prior probabilities and
misclassification cost matrix for a given response variable. It ensures that
the lengths of the prior and the dimensions of the misclassification cost
matrix match the number of levels in the response variable. If \code{prior} or
\code{misClassCost} are not provided, default values are used: the prior is set to
the observed frequencies of the response, and the misclassification cost
matrix is set to 1 for all misclassifications and 0 for correct
classifications.
}
