% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frms.fit.object.R
\docType{class}
\name{fmrs.fit-class}
\alias{fmrs.fit-class}
\alias{frms.fit}
\title{An S4 class to represent a fit of an FMRs model}
\description{
fmrs.fit is an S4 class to represent a fit of FMRs models
resulted from running \code{\link{fmrs.mle}} or \code{\link{fmrs.varsel}}.
}
\section{Slots}{

\describe{
\item{\code{dims}}{A length-three numeric vector represents number of observations
(\code{n}), number of covariates (\code{nCov}) and the order of the mixture
model (\code{nComp})}

\item{\code{coefficients}}{A dimension-\code{nCov}-\code{nComp} numeric matrix}

\item{\code{deviance}}{A length-\code{nComp} numeric vector}

\item{\code{pi}}{A length-\code{nComp} numeric vector}

\item{\code{logLik}}{A length-one numeric vector}

\item{\code{BIC}}{A length-one numeric vector}

\item{\code{nIterEMconv}}{A length-one numeric vector}

\item{\code{disFamily}}{A length-one character vector}

\item{\code{penFamily}}{A length-one character vector}

\item{\code{lambPen}}{A length-\code{nComp} numeric vector}

\item{\code{lamRidge}}{A length-one numeric vector}

\item{\code{method}}{A length-one character vector}

\item{\code{fitted}}{A dimension-\code{n}-\code{nComp} numeric matrix}

\item{\code{residuals}}{A dimension-\code{n}-\code{nComp} numeric matrix}

\item{\code{weights}}{A dimension-\code{n}-\code{nComp} numeric matrix}

\item{\code{data}}{A list including \code{y}, \code{x} and \code{delta}}
}}

