% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmp_get.R
\name{perform_request}
\alias{perform_request}
\title{Perform a request to the Financial Modeling Prep API}
\usage{
perform_request(
  resource,
  params,
  base_url = "https://financialmodelingprep.com/api/",
  api_version = "v3"
)
}
\arguments{
\item{resource}{The specific API resource to be accessed, such as a stock
symbol or financial endpoint.}

\item{params}{Additional query parameters to be included in the API request.}

\item{base_url}{The base URL for the FMP API. Defaults to
"https://financialmodelingprep.com/api/".}

\item{api_version}{The version of the FMP API to use. Defaults to "v3".}
}
\value{
A parsed JSON response from the FMP API.
}
\description{
This function sends a request to the Financial Modeling Prep (FMP) API based
on the specified resource and additional query parameters. It constructs the
request URL using the base API URL and the specified version, and it
automatically includes the API key from the environment.
}
\keyword{internal}
