% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-counters.R
\name{thirty_360_eu}
\alias{thirty_360_eu}
\title{The years between two dates using the 30/360 (EU) day basis convention.}
\usage{
thirty_360_eu(date1, date2)
}
\arguments{
\item{date1}{A date-time object}

\item{date2}{A date-time object}
}
\value{
a numeric value representing the number of years between
\code{date1} and \code{date2}.
}
\description{
This calculates the years between two dates using the 30/360 (EU) day
basis convention. This convention assumes that months consists of 30 days
and years consist of 360 calendar days. This is also known as the 30/360
ICMA, Eurobond (ISDA 2006) and Special German basis.
}
\details{
The day count is determined after making the following (ordered)
modifications:
\enumerate{
\item If the start date is the 31st, set the start date to the 30th
\item If the end date is 31st, set the end date to the 30th
}

The year fraction is then calculated as:
\deqn{\frac{(d_2-d_1) + (m_2-m_1)\times 30 + (y_2-y_1)\times 360}{360}}

The order of \code{date1} and \code{date2} is not important. If \code{date1}
is less than \code{date2} then the result will be non-negative. Otherwise,
the result will be negative.
}
\seealso{
Other counter methods: \code{\link{actual_360}},
  \code{\link{actual_365}},
  \code{\link{actual_actual_isda}},
  \code{\link{is_valid_day_basis}},
  \code{\link{thirty_360_eu_isda}},
  \code{\link{thirty_360_eu_plus}},
  \code{\link{thirty_360_us}}, \code{\link{thirty_360}},
  \code{\link{year_frac}}
}
\keyword{internal}
