#' continuous.rda
#'
#' A data set containing continuous items information.
#' Example data regenerated from CTA1
#'
#' @format A data frame with variables:
#' \describe{
#'   \item{schid}{School ID}
#'   \item{id}{Student ID}
#'   \item{sex}{0 = boys; 1 = girls}
#'   \item{race}{0 = White; 1 = Others}
#'   \item{pretest}{Pre test scores}
#'   \item{stdscore}{Standardized scores}
#'   \item{cm_sex}{Cluster-mean of sex}
#'   \item{cm_race}{Cluster-mean of race}
#'   \item{cm_pretest}{Cluster-mean of Pre test scores}
#'   \item{cm_stdscore}{Cluster-mean of of Standardized scores}
#'   \item{trt}{Treatment assignment; 0 = control, 1 = treatment}
#'   \item{Y}{Outcome}
#'   \item{q1}{Continuous item}
#'   \item{q2}{Continuous item}
#'   \item{q3}{Continuous item}
#'   \item{q4}{Continuous item}
#'   \item{q5}{Continuous item}
#'   \item{q6}{Continuous item}
#'   \item{q7}{Continuous item}
#'   \item{q8}{Continuous item}
#'   \item{q9}{Continuous item}
#'   \item{q10}{Continuous item}
#'   \item{q11}{Continuous item}
#'   \item{q12}{Continuous item}
#'   \item{q13}{Continuous item}
#'   \item{q14}{Continuous item}
#'   \item{q15}{Continuous item}
#'   \item{q16}{Continuous item}
#'   \item{q17}{Continuous item}
#'   \item{q18}{Continuous item}
#'   \item{q19}{Continuous item}
#'   \item{q20}{Continuous item}
#' }
#'
#' @source CTA1
#' @examples
#' data(continuous)
#' summary(continuous)
"continuous"

#' binary.rda
#'
#' A data set containing binary items information.
#' Example data regenerated from CTA1
#'
#' @format A data frame with variables:
#' \describe{
#'   \item{schid}{School ID}
#'   \item{id}{Student ID}
#'   \item{sex}{0 = boys; 1 = girls}
#'   \item{race}{0 = White; 1 = Others}
#'   \item{pretest}{Pre test scores}
#'   \item{stdscore}{Standardized scores}
#'   \item{cm_sex}{Cluster-mean of sex}
#'   \item{cm_race}{Cluster-mean of race}
#'   \item{cm_pretest}{Cluster-mean of Pre test scores}
#'   \item{cm_stdscore}{Cluster-mean of of Standardized scores}
#'   \item{trt}{Treatment assignment; 0 = control, 1 = treatment}
#'   \item{Y}{Outcome}
#'   \item{q1}{Binary item}
#'   \item{q2}{Binary item}
#'   \item{q3}{Binary item}
#'   \item{q4}{Binary item}
#'   \item{q5}{Binary item}
#'   \item{q6}{Binary item}
#'   \item{q7}{Binary item}
#'   \item{q8}{Binary item}
#'   \item{q9}{Binary item}
#'   \item{q10}{Binary item}
#'   \item{q11}{Binary item}
#'   \item{q12}{Binary item}
#'   \item{q13}{Binary item}
#'   \item{q14}{Binary item}
#'   \item{q15}{Binary item}
#'   \item{q16}{Binary item}
#'   \item{q17}{Binary item}
#'   \item{q18}{Binary item}
#'   \item{q19}{Binary item}
#'   \item{q20}{Binary item}
#' }
#'
#' @source CTA1
#' @examples
#' data(binary)
#' summary(binary)
"binary"

#' graded.rda
#'
#' A data set containing graded response items information.
#' Example data regenerated from CTA1
#'
#' @format A data frame with variables:
#' \describe{
#'   \item{schid}{School ID}
#'   \item{id}{Student ID}
#'   \item{sex}{0 = boys; 1 = girls}
#'   \item{race}{0 = White; 1 = Others}
#'   \item{pretest}{Pre test scores}
#'   \item{stdscore}{Standardized scores}
#'   \item{cm_sex}{Cluster-mean of sex}
#'   \item{cm_race}{Cluster-mean of race}
#'   \item{cm_pretest}{Cluster-mean of Pre test scores}
#'   \item{cm_stdscore}{Cluster-mean of of Standardized scores}
#'   \item{trt}{Treatment assignment; 0 = control, 1 = treatment}
#'   \item{Y}{Outcome}
#'   \item{q1}{Graded response item}
#'   \item{q2}{Graded response item}
#'   \item{q3}{Graded response item}
#'   \item{q4}{Graded response item}
#'   \item{q5}{Graded response item}
#'   \item{q6}{Graded response item}
#'   \item{q7}{Graded response item}
#'   \item{q8}{Graded response item}
#'   \item{q9}{Graded response item}
#'   \item{q10}{Graded response item}
#'   \item{q11}{Graded response item}
#'   \item{q12}{Graded response item}
#'   \item{q13}{Graded response item}
#'   \item{q14}{Graded response item}
#'   \item{q15}{Graded response item}
#'   \item{q16}{Graded response item}
#'   \item{q17}{Graded response item}
#'   \item{q18}{Graded response item}
#'   \item{q19}{Graded response item}
#'   \item{q20}{Graded response item}
#' }
#'
#' @source CTA1
#' @examples
#' data(graded)
#' summary(graded)
"graded"
