% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/flows.R
\name{compmat}
\alias{compmat}
\title{Comparison of Two Matrices}
\usage{
compmat(mat1, mat2, digits = 0)
}
\arguments{
\item{mat1}{A square matrix of flows.}

\item{mat2}{A square matrix of flows.}

\item{digits}{An integer indicating the number of decimal places to be used
when printing the data.frame in the console (see \link{round}).}
}
\value{
A data.frame that provides statistics on differences
between mat1 and mat2: absdiff are the
absolute differences and reldiff are the relative differences (in percent).
}
\description{
Compares two matrices of same dimension, with same column and
row names.
}
\examples{
# Import data
data(nav)
myflows <- prepflows(mat = nav, i = "i", j = "j", fij = "fij")

# Remove the matrix diagonal
diag(myflows) <- 0

# Select the dominant flows (incoming flows criterion)
flowSel1 <- domflows(mat = myflows, wi = colSums(myflows), wj = colSums(myflows),
                     k = 1)
# Select the first flows
flowSel2 <- firstflows(mat = myflows, method = "nfirst", ties.method = "first",
                       k = 1)
# Select flows greater than 2000
flowSel3 <- firstflows(mat = myflows, method = "xfirst", k = 2000)

# Combine selections
flowSel <- myflows * flowSel1 * flowSel2 * flowSel3

# Compare flow matrices
compmat(mat1 = myflows, mat2 = flowSel, digits = 1)
}
\seealso{
\link{statmat}
}

