% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{litchi.plan}
\alias{litchi.plan}
\title{Function to generate Litchi csv flight plan}
\usage{
litchi.plan(roi, output, flight.params, gimbal.pitch.angle = -90,
  flight.lines.angle = -1, max.waypoints.distance = 2000,
  max.flight.time = 15, starting.point = 1)
}
\arguments{
\item{roi}{range of interest loaded as an OGR layer, must be in
a metric units projection for working properly}

\item{output}{output path for the csv file}

\item{flight.params}{Flight Parameters. parameters calculated from flight.parameters()}

\item{gimbal.pitch.angle}{gimbal angle for taking photos, default -90 (overriden at flight time)}

\item{flight.lines.angle}{angle for the flight lines, default -1 (auto set based on larger direction)}

\item{max.waypoints.distance}{maximum distance between waypoints in meters,
default 2000 (some issues have been reported with distances > 2 Km)}

\item{max.flight.time}{maximum flight time. If mission is greater than the estimated
time, it will be splitted into smaller missions.}

\item{starting.point}{numeric (1, 2, 3 or 4). Change position from which to start the flight, default 1}
}
\value{
A data frame with the waypoints calculated for the flight plan
}
\description{
Function to generate Litchi csv flight plan
}
\note{
this function will feed the csv flight plan with the `gimbal.pitch.angle`
and the `photo time interval` for each waypoint, but those are not supported
by Litchi yet, although they are present in the exported csv from the
Litchi hub platform, though it may be supported in the future; when it does
the function will already work with this feature.
}
\examples{
library(flightplanning)
data(exampleBoundary)
outPath = tempfile(fileext=".csv")

flight.params = flight.parameters(
  gsd = 4,
  side.overlap = 0.8,
  front.overlap = 0.8,
  flight.speed.kmh = 54
)

litchi.plan(exampleBoundary,
            outPath,
            flight.params,
            flight.lines.angle = -1,
            max.waypoints.distance = 2000,
            max.flight.time = 15)


}
