% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{state_info}
\alias{state_info}
\title{Information on each state}
\format{
A data frame with 51 rows representing airlines and 4 variables:
\describe{
  \item{state}{State name}
  \item{state_abbrev}{State abbreviation}
  \item{division}{US Census designated division. Values for \code{division} are nested within \code{region}}
  \item{region}{US Census designated region}
}
}
\source{
US Census Bureau \url{https://en.wikipedia.org/wiki/List_of_regions_of_the_United_States#Interstate_regions}.
}
\usage{
state_info
}
\description{
State name, abbreviation, US Census designated division & region.
}
\examples{
library(dplyr)
# Number of states in each division
state_info \%>\%
  count(division)
# Number of states in each region
state_info \%>\%
  count(region)
}
\keyword{datasets}
