% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{media_mentions_2020}
\alias{media_mentions_2020}
\alias{media_mentions_cable}
\alias{media_mentions_online}
\title{2020 Presidential Candidates Media Mentions}
\format{
2 dataframes about 2020 presidential candidate media mentions

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 954 rows and 6 columns.
}
\source{
The GDELT Television API \url{https://blog.gdeltproject.org/gdelt-2-0-television-api-debuts/}, which processes the data from the TV News Archive \url{https://archive.org/details/tv}.

Two collections in the Media Cloud \url{https://mediacloud.org/} database U.S. Top Online News \url{https://sources.mediacloud.org/#/collections/58722749} and U.S. Top Digital Native News \url{https://sources.mediacloud.org/#/collections/57078150}
}
\usage{
media_mentions_cable

media_mentions_online
}
\description{
The raw data behind the story
"Beto O'Rourke Ignored Cable News - And It Ignored Him"
\url{https://fivethirtyeight.com/features/beto-orourke-ignored-cable-news-and-it-ignored-him/}
}
\section{media_mentions_cable}{

A data frame with 972 rows representing weeks of cable coverage and 7 variables:
\describe{
  \item{date}{start date for the week of coverage}
  \item{name}{candidate's name}
  \item{matched_clips}{number of 15-second clips in that week that mention the specified candidate}
  \item{all_candidate_clips}{number of 15-second clips in that week that mention any candidates}
  \item{total_clips}{total number of 15-second clips that week across the three networks}
  \item{pct_of_all_candidate_clips}{percentage of clips in which that specific candidate is mentioned out of all clips mentioning any candidate for that week (matched_clips / all_candidate_clips)}
  \item{query}{query used for the GDELT Television API}
}
}

\section{media_mentions_online}{
  
A data frame with 954 rows representing weeks and 6 variables:
\describe{
  \item{date}{start date for the week of coverage}
  \item{name}{candidate's name}
  \item{matched_stories}{number of stories in that week that mention the specified candidate}
  \item{all_candidate_stories}{number of stories in that week that mention any candidate}
  \item{pct_of_all_candidate_stories}{percentage of stories in which that specific candidate is mentioned out of all stories mentioning any candidate for that week (matched_stories / all_candidate_stories)}
  \item{query}{query for Media Cloud}
}
}

\keyword{datasets}
