% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddBin.R
\name{NegLLAddBin}
\alias{NegLLAddBin}
\title{Negative Log Likelihood value of Additive Binomial distribution}
\usage{
NegLLAddBin(x,freq,p,alpha)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{p}{single value for probability of success.}

\item{alpha}{single value for alpha parameter.}
}
\value{
The output of \code{NegLLAddBin} will produce a single  numeric value.
}
\description{
This function will calculate the negative log likelihood value when the vector of binomial random
variable and vector of corresponding frequencies are given with the input parameters.
}
\details{
\deqn{freq \ge 0}
\deqn{x = 0,1,2,..}
\deqn{0 < p < 1}
\deqn{-1 < alpha < 1}
}
\examples{
No.D.D <- 0:7          #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)         #assigning the corresponding frequencies

NegLLAddBin(No.D.D,Obs.fre.1,.5,.03)         #acquiring the negative log likelihood value

}
\references{
\insertRef{johnson2005univariate}{fitODBOD}
\insertRef{kupper1978use}{fitODBOD}
\insertRef{paul1985three}{fitODBOD}
\insertRef{morel2012overdispersion}{fitODBOD}
}
