% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{pGrassiaIIBin}
\alias{pGrassiaIIBin}
\title{Grassia-II-Binomial Distribution}
\usage{
pGrassiaIIBin(x,n,a,b)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{n}{single value for no of binomial trials.}

\item{a}{single value for shape parameter a.}

\item{b}{single value for shape parameter b.}
}
\value{
The output of \code{pGrassiaIIBin} gives cumulative probability  values in vector form.
}
\description{
These functions provide the ability for generating probability function values and
cumulative probability function values for the Grassia-II-Binomial Distribution.
}
\details{
Mixing Gamma distribution with Binomial distribution will create the the Grassia-II-Binomial
distribution, only when (1-p)=e^(-lambda) of the Binomial distribution. The probability function and
cumulative probability function can be constructed and are denoted below.

The cumulative probability function is the summation of probability function values.

\deqn{P_{GrassiaIIBin}[x]= {n \choose x} \sum_{j=0}^{x} {x \choose j} (-1)^{x-j} (1+b(n-j))^{-a} }
\deqn{a,b > 0}
\deqn{x = 0,1,2,...,n}
\deqn{n = 1,2,3,...}

The mean, variance and over dispersion are denoted as
\deqn{E_{GrassiaIIBin}[x] = (\frac{b}{b+1})^a}
\deqn{Var_{GrassiaIIBin}[x] = n^2[(\frac{b}{b+2})^a - (\frac{b}{b+1})^{2a}] + n(\frac{b}{b+1})^a{1-(\frac{b+1}{b+2})^a}}
\deqn{over dispersion= \frac{(\frac{b}{b+2})^a - (\frac{b}{b+1})^{2a}}{(\frac{b}{b+1})^a[1-(\frac{b}{b+1})^a]}}
}
\examples{
#plotting the random variables and probability values
col <- rainbow(5)
a <- c(0.3,0.4,0.5,0.6,0.8)
plot(0,0,main="Grassia II binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,0.5))
for (i in 1:5)
{
lines(0:10,dGrassiaIIBin(0:10,10,2*a[i],a[i])$pdf,col = col[i],lwd=2.85)
points(0:10,dGrassiaIIBin(0:10,10,2*a[i],a[i])$pdf,col = col[i],pch=16)
}

dGrassiaIIBin(0:10,10,4,.2)$pdf    #extracting the pdf values
dGrassiaIIBin(0:10,10,4,.2)$mean   #extracting the mean
dGrassiaIIBin(0:10,10,4,.2)$var    #extracting the variance
dGrassiaIIBin(0:10,10,4,.2)$over.dis.para  #extracting the over dispersion value

#plotting the random variables and cumulative probability values
col <- rainbow(4)
a <- c(0.3,0.4,0.5,0.6)
plot(0,0,main="Cumulative probability function graph",xlab="Binomial random variable",
ylab="Cumulative probability function values",xlim = c(0,10),ylim = c(0,1))
for (i in 1:4)
{
lines(0:10,pGrassiaIIBin(0:10,10,2*a[i],a[i]),col = col[i])
points(0:10,pGrassiaIIBin(0:10,10,2*a[i],a[i]),col = col[i])
}

pGrassiaIIBin(0:10,10,4,.2)   #acquiring the cumulative probability values

}
\references{
Grassia, A., 1977. On a family of distributions with argument between 0 and 1
obtained by transformation of the gamma and derived compound distributions.
Australian Journal of Statistics, 19(2), pp.108-114.
}
